unit InstanceManager;

interface

const UniqueAppName = 'eyeOS MicroServer running instance';
AppNotifyValue: integer = 0;

var rcvStr: string;
   rcvValue: integer;
   ForbidOtherInstance: boolean = True;
   triggerProc: procedure of object;

implementation

uses Windows, SysUtils, Messages;

var mutex, thisWnd: HWND;
   IMWndClass: TWndClassA;
   mustHalt: boolean;
   copydata: TCOPYDATASTRUCT;

function IMWndProc(HWindow: HWnd; Message, WParam: Longint; LParam: Longint): Longint; stdcall;
begin
   if Message=WM_COPYDATA then
   begin
     rcvStr := StrPas(PCOPYDATASTRUCT(lParam).lpData);
     rcvValue := PCOPYDATASTRUCT(lParam).dwData;
     if Assigned(triggerProc) then triggerProc;
     Result := Ord(ForbidOtherInstance);
   end
   else
   Result := DefWindowProc(hWindow, Message, WParam, LParam);
end;

initialization

FillChar(IMWndClass, SizeOf(IMWndClass), 0);
IMWndClass.lpfnWndProc := @IMWndProc;
IMWndClass.hInstance := HINSTANCE;
IMwndClass.lpszClassName := 'TInstanceManager';
if Windows.RegisterClass(IMWndClass) = 0 then RaiseLastOSError;
mutex := CreateMutex(nil, True, UniqueAppName);
if GetLastError = ERROR_ALREADY_EXISTS then
begin
   mustHalt := True;
   if WaitForSingleObject(mutex, 5000)=WAIT_OBJECT_0 then
   begin
     thisWnd := FindWindow(IMwndClass.lpszClassName, UniqueAppName);
     if thisWnd = 0 then RaiseLastOSError;
     CopyData.dwData := AppNotifyValue;
     CopyData.lpData := CmdLine;
     CopyData.cbData := StrLen(CmdLine);
     mustHalt := (SendMessage(thisWnd,WM_COPYDATA,0,Integer(@CopyData))>0);
   end;
   thisWnd := 0;
   ReleaseMutex(mutex);
   if mustHalt then Halt;
end
else begin
   thisWnd := CreateWindow(IMwndClass.lpszClassName,
   UniqueAppName,0,0,0,0,0,0,0,hInstance, nil);
   if thisWnd = 0 then RaiseLastOSError;
   ReleaseMutex(mutex);
end;
finalization
   if thisWnd>0 then DestroyWindow(thisWnd);

end.
