{*******************************************************}
{       This unit is part of eyeOS microserver          }
{                                                       }
{ Author:                                               }
{ Bjrn Ahrens                                          }
{ bjoern@ahrens.net                                     }
{ http://bjoern.ahrens.net                              }
{*******************************************************}

unit Languages;

interface

uses Classes;

type
  TLanguages = class
    private
      FLangs       : TStringList;
      FTranslation : TStringList;
      FSelected    : String;
      function GetCount: Integer;
      function GetLanguages(Index: Integer): String;
      procedure SetSelected(const Value: String);
    protected
    public
      constructor Create (const ABaseDir : String);
      destructor Destroy (); override;

      function Translate (const AStr : String) : String;

      property Count : Integer read GetCount;
      property Languages [Index : Integer] : String read GetLanguages;
      property Selected : String read FSelected write SetSelected;
  end;

implementation

uses SysUtils;

{ TLanguages }

function TLanguages.GetCount: Integer;
begin
  Result:=FLangs.Count;
end;

function TLanguages.GetLanguages(Index: Integer): String;
begin
  Result:=FLangs.Names[Index];
end;

procedure TLanguages.SetSelected(const Value: String);
var       idx : Integer;
begin
  FreeAndNil(FTranslation);
  idx:=FLangs.IndexOfName(Value);
  if (idx>=0) then
    FSelected := Value
  else
    FSelected:='';
end;

constructor TLanguages.Create(const ABaseDir: String);
var         SRec : TSearchRec;
            sl   : TStringList;
            path : String;
begin
  FLangs:=TStringList.Create();
  FSelected:='';
  FTranslation:=nil;
  path:=IncludeTrailingPathDelimiter(ABaseDir);

  sl:=TStringList.Create();
  try
    if (FindFirst(path+'*.lng',faAnyFile,SRec)=0) then begin
      repeat
        sl.LoadFromFile(path+SRec.Name);
        if (sl.Count>0) then
          FLangs.Values[Trim(sl[0])]:=path+SRec.Name;
      until (FindNext(SRec)<>0);
      FindClose(SRec);
    end;
  except
  end;
  sl.Free();
end;

function TLanguages.Translate(const AStr: String): String;
var      idx : Integer;
begin
  if (FTranslation=nil) then begin
    idx:=FLangs.IndexOfName(FSelected);
    if (idx>=0) and FileExists(FLangs.ValueFromIndex[idx]) then begin
      FTranslation:=TStringList.Create();
      FTranslation.LoadFromFile(FLangs.ValueFromIndex[idx]);
    end else begin
      Result:=AStr;
      exit;
    end;
  end;
  Result:=Trim(FTranslation.Values[AStr]);
  if (Result='') then
    Result:=AStr;
end;

destructor TLanguages.Destroy;
begin
  FLangs.Free();
  FTranslation.Free();
  inherited;
end;

end.
