{*******************************************************}
{       This unit is part of eyeOS microserver          }
{                                                       }
{ Author:                                               }
{ Bjrn Ahrens                                          }
{ bjoern@ahrens.net                                     }
{ http://bjoern.ahrens.net                              }
{*******************************************************}

unit upnp;

interface

  function AddMapping (AExtPort : Integer; AProtocol : String; AIntPort : Integer; Active : Boolean; ADesc : String) : Boolean;
  function RemoveMapping (AExtPort : Integer; AProtocol : String) : Boolean;

implementation

uses sysutils, winsock, windows, NATUPNPLib_TLB;

function AddMapping (AExtPort : Integer; AProtocol : String; AIntPort : Integer; Active : Boolean; ADesc : String) : Boolean;
var       NAT    : IUPnPNAT;
          mapcol : IStaticPortMappingCollection;
          map    : IStaticPortMapping;

  function LocalIP: string;
  type
     TaPInAddr = array [0..10] of PInAddr;
     PaPInAddr = ^TaPInAddr;
  var
      phe: PHostEnt;
      pptr: PaPInAddr;
      Buffer: array [0..63] of char;
      i: Integer;
      GInitData: TWSADATA;
  begin
      WSAStartup($101, GInitData);
      Result := '';
      GetHostName(Buffer, SizeOf(Buffer));
      phe :=GetHostByName(buffer);
      if phe = nil then Exit;
      pptr := PaPInAddr(Phe^.h_addr_list);
      i := 0;
      while pptr^[i] <> nil do
      begin
        result:=StrPas(inet_ntoa(pptr^[i]^));
        Inc(i);
      end;
      WSACleanup;
  end;

begin
  try
    Nat:=CoUPnPNAT.Create();
    mapcol:=Nat.StaticPortMappingCollection;
    map:=mapcol.Add(AExtPort,AProtocol,AIntPort,LocalIP,Active,ADesc);
    Result:=(map<>nil);
  except
    Result:=false;
  end;
end;


function RemoveMapping (AExtPort : Integer; AProtocol : String) : Boolean;
var       NAT    : IUPnPNAT;
          mapcol : IStaticPortMappingCollection;
begin
  try
    Nat:=CoUPnPNAT.Create();
    mapcol:=Nat.StaticPortMappingCollection;
    mapcol.Remove(AExtPort,AProtocol);
    Result:=true;
  except
    Result:=false;
  end;
end;

end.
