{*******************************************************}
{       This unit is part of eyeOS microserver          }
{                                                       }
{ Author:                                               }
{ Bjrn Ahrens                                          }
{ bjoern@ahrens.net                                     }
{ http://bjoern.ahrens.net                              }
{*******************************************************}

unit MainForm;
{-------------------------------------------------------------------------------}
{-------------------------------------------------------------------------------}
interface
{-------------------------------------------------------------------------------}
{-------------------------------------------------------------------------------}

uses
  Windows, Messages, SysUtils, Classes, Controls, Forms,
  IdCustomHTTPServer,
  IdHeaderList,
  IdHTTPServer,
  IdContext,
  idPHPRunner,
  StdCtrls,
  Menus,
  CoolTrayIcon,
  ActnPopup,
  SyncObjs,
  IdObjs,
  IdSMTP,
  IdSMTPServer,
  IdDNSResolver,
  WindowsFirewall,
  PHPInis,
  Dialogs,
  Languages,
  ComCtrls,
  Graphics,
  ExtCtrls,
  ImgList,
  IdHTTP;

{-------------------------------------------------------------------------------}

type
  TfmMain = class(TForm)
    CoolTrayIcon1: TCoolTrayIcon;
    PopupActionBar1: TPopupActionBar;
    miOpenInDefaultBrowser: TMenuItem;
    Exit1: TMenuItem;
    ImageList1: TImageList;
    Settings1: TMenuItem;
    N1: TMenuItem;
    btnOK: TButton;
    PageControl1: TPageControl;
    tshServer: TTabSheet;
    tshSMTP: TTabSheet;
    tshAbout: TTabSheet;
    lblVersion: TLabel;
    lblSMTP: TLabel;
    gbxExternalSMPT: TGroupBox;
    edtSMTPHost: TLabeledEdit;
    edtUsername: TLabeledEdit;
    edtPassword: TLabeledEdit;
    chbSMTPActive: TCheckBox;
    tshMisc: TTabSheet;
    gbxPHP: TGroupBox;
    UpDown1: TUpDown;
    edtMaxUpload: TLabeledEdit;
    tshLog: TTabSheet;
    gbxPortSettings: TGroupBox;
    edtServerPort: TLabeledEdit;
    chbUPNP: TCheckBox;
    chbWinFirewall: TCheckBox;
    btnCancel: TButton;
    edtSMTPServerPort: TLabeledEdit;
    rgpIPRanges: TRadioGroup;
    gbxMiscServerSettings: TGroupBox;
    chbZLib: TCheckBox;
    Image1: TImage;
    lblDevBy: TLabel;
    gbxInfo: TGroupBox;
    lblComponents: TLabel;
    Label3: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    Label8: TLabel;
    Label9: TLabel;
    Label10: TLabel;
    lblEyeOSHome: TLabel;
    gbxGeneral: TGroupBox;
    chbAutoStart: TCheckBox;
    RichEdit1: TMemo;
    chbUpdates: TCheckBox;
    btnUpdates: TButton;
    miServerActive: TMenuItem;
    N2: TMenuItem;
    chbNeverDirectMail: TCheckBox;
    chbEnableTLS: TCheckBox;
    lblOpenSSL: TLabel;
    lblOpenSSLDownload: TLabel;
    btnConfigTLS: TButton;
    gbxLanguage: TGroupBox;
    cbxLanguage: TComboBox;
    gbxEyeOS: TGroupBox;
    chbPreferUpdate: TCheckBox;
    procedure FormShow(Sender: TObject);
    procedure btnConfigTLSClick(Sender: TObject);
    procedure lblOpenSSLDownloadClick(Sender: TObject);
    procedure chbSMTPActiveClick(Sender: TObject);
    procedure miServerActiveClick(Sender: TObject);
    procedure btnUpdatesClick(Sender: TObject);
    procedure lblEyeOSHomeClick(Sender: TObject);
    procedure Label10Click(Sender: TObject);
    procedure Label8Click(Sender: TObject);
    procedure Label7Click(Sender: TObject);
    procedure Label6Click(Sender: TObject);
    procedure Label3Click(Sender: TObject);
    procedure btnCancelClick(Sender: TObject);
    procedure IdSMTPServer1MsgReceive(ASender: TIdSMTPServerContext;
      AMsg: TStream; var LAction: TIdDataReply);
    procedure IdSMTPServer1MailFrom(ASender: TIdSMTPServerContext;
      const AAddress: string; AParams : TIdStrings; var VAction: TIdMailFromReply);
    procedure IdSMTPServer1Connect(AContext: TIdContext);
    procedure IdSMTPServer1RcptTo(ASender: TIdSMTPServerContext;
      const AAddress: string; AParams : TIdStrings; var VAction: TIdRCPToReply; var VForward: string);
    procedure FormDestroy(Sender: TObject);
    procedure IdHTTPServer2CreatePostStream(AContext: TIdContext;
      AHeaders: TIdHeaderList; var VPostStream: TStream);
    procedure btnOKClick(Sender: TObject);
    procedure miOpenInDefaultBrowserClick(Sender: TObject);
    procedure Settings1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure Exit1Click(Sender: TObject);
    procedure IdHTTPServer2CommandGet(AContext: TIdContext;
      ARequestInfo: TIdHTTPRequestInfo; AResponseInfo: TIdHTTPResponseInfo);
  private
    { Private declarations }
    firewall      : TWindowsFirewall;
    HttpServer    : TIdHTTPServer;
    SmtpServer    : TIdSMTPServer;
    upnpset       : Boolean;
    phpini        : TPHPIni;
    Initialized   : Boolean;
    FActive       : Boolean;
    PHPRunner     : TidPHPRunner;

    procedure DoTrigger ();
    procedure IdHTTPServer1Connect(AContext: TIdContext);
    procedure UpdateSettingControls ();
    procedure UpdateSMTPPage ();
    function GetDNS () : String;
    procedure UpdateCaptions ();

    procedure CheckForUpdate (Popup : Boolean);
    procedure SetServerActive(const Value: Boolean);

    procedure GetCertPW (var Password: String);
  protected
     procedure CreateParams(var Params: TCreateParams); override;
  public
    lang          : TLanguages;

    { Public declarations }
    procedure ChangeFirewallState (Open : Boolean);
    procedure ChangeUPnPState (Mapped : Boolean);
    procedure ReStartHttpServer ();
    procedure ReStartSMTPServer ();
    procedure StopServers ();

    property ServerActive : Boolean read FActive write SetServerActive;
  end;

var
  fmMain: TfmMain;

resourcestring
  rsVersion = '0.6.2';

  capBtnOK = 'OK';
  capBtnCancel = 'Cancel';
  capTshMisc = 'Misc.';
  capGbxGeneral = 'General';
  capChbAutoStart = 'Start MicroServer at Windows startup';
  capLblLanguage = 'Language';
  capGbxPHP = 'PHP settings';
  capEdtMaxUpload = 'Max. upload size (MB)';
  capTshServer = 'Server';
  capGbxPortSettings = 'Port settings';
  capEdtServerPort = 'Server port';
  capChbWinFirewall = 'Open MicroServer in Windows Firewall';
  capChbUPNP = 'Enable UPnP';
  capRgpIPRanges = 'Allowed IP ranges';
  capRgpIPRanges_item0 = 'all (including internet)';
  capRgpIPRanges_Item1 = 'local subnet';
  capRgpIPRanges_Item2 = 'localhost';
  capGbxMiscServerSettings = 'Misc. settings';
  capChbZLib = 'enable ZLib compression';
  capTshSMTP = 'SMTP';
  capLblSMTP1 = 'If you use eyeOS MicroServer on a dial-up machine most SMTP servers will reject mails from the MicroServer.';
  capLblSMTP2 = 'In this case you have to enter a valid SMTP host address with username and password so MicroServer can act as mail client to sent validation eMails using your mail account.';
  capChbSMTPActive = 'Activate SMTP server';
  capEdtSMTPServerPort = 'Server port:';
  capGbxExternalSMTP = 'Settings for external SMTP';
  capChbNeverDirectMal = 'Send mail only using external SMTP';
  capEdtSMTPHost = 'SMTP host address';
  capEdtUsername = 'Username';
  capEdtPassword = 'Password';
  capTshAbout = 'About';
  capLblVersion = 'Version';
  capLBLDevBy = 'developed by';
  capLblEyeOsHome = 'visit the official eyeOS homepage';
  capGbxInfo = 'Info';
  capLblComponents = 'eyeOS MicroServer includes following third party components:';
  capTshLog = 'Log';

  capShow2 = 'Open in default Browser';
  capExit1 = 'Exit';
  capSettings1 = 'Settings';

  errPortNumber = 'Please enter a valid port number';
  statSMTPStopped = 'SMTP server stopped';
  statRestart = 'Settings will be applied next start of MicroServer.';
  errUPnPClosedInFW = 'UPnP ports closed in Windows firewall';
  statUPnPSet = 'UPnP: Mapping successfully set';
  errUPnPSet = 'UPnP: Error setting mapping';
  statUPnPRemoved = 'UPnP: Mapping successfully removed';
  errUPnPRemove = 'UPnP: Error removing mapping';
  statSMTPStarted = 'SMTP server listening on port %d';

  txtMostRecentVersion = 'Your version is the most recent.';
  capNewVersion = 'New version available';
  txtNewVersion = 'A new version of MicroServer was found.';
  txtVersionDiff = 'Installed: %s, found: %s.';
  txtDownloadVersion ='Download new Version?';

  capChbUpdates = 'Check for new version at startup';
  capBtnUpdates = 'Check for new version';

  txtServerPortInUse = 'MicroServer port (%d) already in use by another program. End other program or change server port.';
  txtSMTPPortInUse = 'MicroServer SMTP port (%d) already in use by another program. End other program or change SMTP port.';
  statServerStopped = 'MicroServer stopped';
  statServerStarted = 'MicroServer listening on port %d';
  statFirewallOpened = 'MicroServer opened in firewall';
  statFirewallAlreadyOpen = 'MicroServer already opened in firewall';
  capMiServerActive = 'MicroServer active';
  statServerRemoved = 'MicroServer removed from firewall';

  // > 0.5.5
  errUpdateSocketError = 'Updatecheck failed. Error connecting to eyeos.org';
  capChbEnableTLS = 'Enable TLS';
  capLblOpenSSL = 'TSL support requires OpenSSL libraries which have to be installed separately.';
  capLblOpenSSLDownload = 'Download a Win32 Installer for OpenSSL.';

  //> 0.6
  capFmTLSConfig = 'TLS configuration';
  capEdtCertFile = 'Certificate file';
  capEdtKeyFile = 'Private key file';
  capEdtKeyPassword = 'Private key password';
  capChbSavePassword = 'Save password';
  capBtnTLSConfig = 'Config';

  //>= 0.6.2
  capGbxEyeOS = 'eyeOS';
  capChbPreferUpdate = 'prefer update.php over index.php';

{-------------------------------------------------------------------------------}
{-------------------------------------------------------------------------------}
implementation
{-------------------------------------------------------------------------------}
{-------------------------------------------------------------------------------}

uses upnp, IdReplySMTP, IdMessage, IdGlobal, ShellApi, IniFiles,
  InstanceManager, SettingsUnit, ZendAPI, PHPTypes, IdZLib,
  IdException, IdStack, IdSSLOpenSSL, TLSConfigForm;

{$R *.dfm}

{-------------------------------------------------------------------------------}
{-------------------------------------------------------------------------------}
function GetDNSbyIpHlp: string;
type
  PTIP_ADDRESS_STRING = ^TIP_ADDRESS_STRING;
  TIP_ADDRESS_STRING = array[0..15] of char;
  PTIP_ADDR_STRING = ^TIP_ADDR_STRING;
  TIP_ADDR_STRING = packed record
    Next: PTIP_ADDR_STRING;
    IpAddress: TIP_ADDRESS_STRING;
    IpMask: TIP_ADDRESS_STRING;
    Context: DWORD;
  end;
  PTFixedInfo = ^TFixedInfo;
  TFixedInfo = packed record
    HostName: array[1..128 + 4] of char;
    DomainName: array[1..128 + 4] of char;
    CurrentDNSServer: PTIP_ADDR_STRING;
    DNSServerList: TIP_ADDR_STRING;
    NodeType: UINT;
    ScopeID: array[1..256 + 4] of char;
    EnableRouting: UINT;
    EnableProxy: UINT;
    EnableDNS: UINT;
  end;
const
  IpHlpDLL = 'IPHLPAPI.DLL';
var
  IpHlpModule: THandle;
  FixedInfo: PTFixedInfo;
  InfoSize: Longint;
  PDnsServer: PTIP_ADDR_STRING;
  err: integer;
  GetNetworkParams: function(FixedInfo: PTFixedInfo; pOutPutLen: PULONG): DWORD; stdcall;
begin
  InfoSize := 0;
  Result := '...';
  IpHlpModule := LoadLibrary(IpHlpDLL);
  if IpHlpModule = 0 then
    exit;
  try
    GetNetworkParams := GetProcAddress(IpHlpModule,'GetNetworkParams');
    if @GetNetworkParams = nil then
      Exit;
    err := GetNetworkParams(Nil, @InfoSize);
    if err <> ERROR_BUFFER_OVERFLOW then
      Exit;
    Result := '';
    GetMem (FixedInfo, InfoSize);
    try
      err := GetNetworkParams(FixedInfo, @InfoSize);
      if err <> ERROR_SUCCESS then
        exit;
      with FixedInfo^ do
      begin
        Result := DnsServerList.IpAddress;
        PDnsServer := DnsServerList.Next;
        while PDnsServer <> Nil do
        begin
          if Result <> '' then
            Result := Result + ',';
          Result := Result + PDnsServer^.IPAddress;
          PDnsServer := PDnsServer.Next;
        end;
    end;
    finally
      FreeMem(FixedInfo);
    end;
  finally
    FreeLibrary(IpHlpModule);
  end;
end;
{-------------------------------------------------------------------------------}
function ReadReg(SubKey, Vn: PChar): string;
var
 OpenKey: HKEY;
 DataType, DataSize: integer;
 Temp: array [0..2048] of char;
begin
  Result := '';
  if RegOpenKeyEx(HKEY_LOCAL_MACHINE, SubKey, REG_OPTION_NON_VOLATILE,
    KEY_READ, OpenKey) = ERROR_SUCCESS then
  begin
    DataType := REG_SZ;
    DataSize := SizeOf(Temp);
    if RegQueryValueEx(OpenKey, Vn, nil, @DataType, @Temp, @DataSize) = ERROR_SUCCESS then
      Result := string(Temp);
    RegCloseKey(OpenKey);
   end;
end;
{-------------------------------------------------------------------------------}
{ TfmMain }
{-------------------------------------------------------------------------------}
procedure TfmMain.IdHTTPServer2CommandGet(AContext: TIdContext;
  ARequestInfo: TIdHTTPRequestInfo; AResponseInfo: TIdHTTPResponseInfo);
var       fileName : String;
          stream  : TStream;
          acceptsdeflate : Boolean;

          s : String;
begin
  if (Copy(ExpandFileName(Settings.HttpRootpath+ARequestInfo.Document),1,Length(Settings.HttpRootPath))<>Settings.HttpRootPath) then begin
    AResponseInfo.ResponseNo:=403;
    AResponseInfo.ContentText:='403 Forbidden';
    exit;
  end;

  acceptsdeflate:=(pos('deflate',ARequestInfo.AcceptEncoding)>0);

  if (ARequestInfo.Document='') or (ARequestInfo.Document='/') then begin
    if FileExists(Settings.HttpRootPath+'\update.php') and (Settings.eyeOS_PreferUpdate) then
      filename:='\update.php'
    else if FileExists(Settings.HttpRootPath+'\index.php') then
      filename:='\index.php'
    else if FileExists(Settings.HttpRootPath+'\install.php') then
      filename:='\install.php'
    else begin
      AResponseInfo.ResponseNo:=404;
      AResponseInfo.ContentText:='Neither index.php, install.php nor update.php found.';
      AResponseInfo.ContentType:='text/plain';
      exit;
    end;
  end else
    filename:=StringReplace(ARequestInfo.Document,'/','\',[rfReplaceAll]);

    s:=ExpandFileName(Settings.HttpRootPath+fileName);
  if (Copy(s,1,Length(Settings.HttpRootPath)+1)<>IncludeTrailingPathDelimiter(Settings.HttpRootPath)) then begin
    AResponseInfo.ResponseNo:=403;
    AResponseInfo.ContentText:='403 Forbidden';
    AResponseInfo.ContentType:='text/plain';
    {Relative Pfade berprfen!!!!!}
  end else if FileExists(Settings.HttpRootPath+fileName) then begin
    if lowercase(ExtractFileExt(filename))='.php' then begin
      PHPRunner.Execute(filename,AContext,ARequestInfo,AResponseInfo,Settings.HttpRootPath);

      if Settings.HttpZLib and acceptsdeflate
         and (AResponseInfo.ContentStream<>nil)
         and (AResponseInfo.ContentStream.Size>0) then begin
        stream:=TMemoryStream.Create();
        AResponseInfo.ContentStream.Position:=0;
        CompressStream(AResponseInfo.ContentStream,stream);
        AResponseInfo.ContentStream.Free();
        AResponseInfo.ContentStream:=stream;
        AResponseInfo.ContentEncoding:='deflate';
      end;

    end else begin
      AResponseInfo.ContentType:=HTTPServer.MIMETable.GetFileMIMEType(Settings.HttpRootPath+fileName);
      if acceptsdeflate and Settings.HttpZLib then begin
        AResponseInfo.ContentStream:=TMemoryStream.Create();
        stream:=TFileStream.Create(Settings.HttpRootPath+fileName,fmOpenRead);
        CompressStream(stream,AResponseInfo.ContentStream);
        stream.Free();
        AResponseInfo.ContentEncoding:='deflate';
      end else
        AResponseInfo.ServeFile(AContext,Settings.HttpRootPath+fileName);
    end;
  end else begin
    AResponseInfo.ResponseNo:=404;
    AResponseInfo.ContentText:='404 File not found';
    AResponseInfo.ContentType:='text/plain';
  end;
end;
{-------------------------------------------------------------------------------}
procedure TfmMain.Exit1Click(Sender: TObject);
begin
  CoolTrayIcon1.HideTaskbarIcon();
  HTTPServer.Active:=false;
  Application.Terminate;
end;
{-------------------------------------------------------------------------------}
procedure TfmMain.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
begin
end;
{-------------------------------------------------------------------------------}
procedure TfmMain.FormCreate(Sender: TObject);
begin
  HttpServer:=nil;
  SmtpServer:=nil;
  Initialized:=false;
  PHPRunner:=TidPHPRunner.Create(self);
  PHPRunner.Loaded;

  Settings(); //Debug line
  lang:=TLanguages.Create(Settings.ProgPath);
  UpdateCaptions();

  firewall:=TWindowsFirewall.Create();
  InstanceManager.TriggerProc:=DoTrigger;

  phpini:=TPHPIni.Create(Settings.ProgPath+'php.ini');
  phpini.ChangeSetting('smtp_port',IntToStr(Settings.SmtpServerPort));
  phpini.ChangeSetting('upload_max_filesize',IntToStr(Settings.PHPMaxUpload)+'M');
  phpini.ChangeSetting('post_max_size',IntToStr(Settings.PHPMaxUpload)+'M');
  phpini.ChangeSetting('memory_limit',IntToStr(Settings.PHPMaxUpload)+'M');
  phpini.Save();

  ChangeFirewallState(true);
  ChangeUPnPState(Settings.HttpUPnP);

  ServerActive:=true;
  
  if (Settings.CheckForUpdates) then
    CheckForUpdate(false);
end;
{-------------------------------------------------------------------------------}
procedure TfmMain.Settings1Click(Sender: TObject);
begin
  PageControl1.ActivePage:=tshAbout;
  UpdateSettingControls();
  CoolTrayIcon1.ShowMainForm();
end;
{-------------------------------------------------------------------------------}
procedure TfmMain.miOpenInDefaultBrowserClick(Sender: TObject);
begin
  if (Settings.UseTLS) then
    ShellExecute(Application.MainForm.Handle, 'open', PCHAR('https://127.0.0.1:'+IntToStr(Settings.HttpPort)), NIL, NIL, SW_SHOW)
  else
    ShellExecute(Application.MainForm.Handle, 'open', PCHAR('http://127.0.0.1:'+IntToStr(Settings.HttpPort)), NIL, NIL, SW_SHOW);
end;
{-------------------------------------------------------------------------------}
procedure TfmMain.btnOKClick(Sender: TObject);
var       i : Integer;
          phpchanged : Boolean;
begin
  phpchanged:=false;

  try
    i:=StrToInt(edtServerPort.Text);
    if (i<0) or (i>High(Word)) then
      raise Exception.Create('');
  except
    ShowMessage(lang.Translate(errPortNumber));
    PageControl1.ActivePage:=tshServer;
    edtServerPort.SetFocus();
    exit;
  end;

  try
    i:=StrToInt(edtSMTPServerPort.Text);
    if (i<0) or (i>High(Word)) then
      raise Exception.Create('');
  except
    ShowMessage(lang.Translate(errPortNumber));
    PageControl1.ActivePage:=tshSMTP;
    edtSMTPServerPort.SetFocus();
    exit;
  end;

  {"Unkritische" Einstellungen zuerst bernehmen}
  Settings.HTTPIPRanges:=rgpIPRanges.ItemIndex;
  Settings.HttpZLib:=chbZLib.Checked;

  Settings.SmtpHost:=edtSMTPHost.Text;
  Settings.SmtpUsername:=edtUsername.Text;
  Settings.SmtpPassword:=edtPassword.Text;
  Settings.SmtpNeverDirect:=chbNeverDirectMail.Checked;

  if (Settings.HttpFirewall<>chbWinFirewall.Checked) then begin
    Settings.HttpFirewall:=chbWinFirewall.Checked;
    ChangeFirewallState(Settings.HttpFirewall);
  end;

  {"Kritische" (weil Server-Neustarts ggf. erforderlich) Einstellugnen}
  if (Settings.HttpPort<>StrToInt(edtServerPort.Text))
     or (Settings.UseTLS<>chbEnableTLS.Checked) then begin
    {Server mit neuem Port neu starten}

    {Server lschen, damit Firewall nicht mault}
    ServerActive:=false;

    {UPnP und Firewall rckgngig machen}
    ChangeUPnPState(false);

    {Einstellungen bernehmen}
    Settings.HttpPort:=StrToInt(edtServerPort.Text);
    Settings.HttpUPnP:=chbUPNP.Checked;
    Settings.HttpFirewall:=chbWinFirewall.Checked;
    Settings.UseTLS:=chbEnableTLS.Checked;

    {UPnP und Firewall entsprechend anpassen}
    ChangeUPnPState(Settings.HttpUPnP);

    {Vor Neustart SMTP-Einstellungen prfen und ggf. bernehmen}
    if (Settings.SmtpServerPort<>StrToInt(edtSMTPServerPort.Text)) then begin
      Settings.SmtpServerPort:=StrToInt(edtSMTPServerPort.Text);
      PHPIni.ChangeSetting('smtp_port',IntToStr(Settings.SmtpServerPort));
      PHPIni.Save();
      phpchanged:=true;
    end;

    if (Settings.SmtpActive<>chbSMTPActive.Checked) then begin
      Settings.SmtpActive:=chbSMTPActive.Checked;
    end;

    {Server neu starten}
    ServerActive:=true;
  end else begin
    {Einstellungen bernehmen}
    {und UPnP und Firewall entsprechend anpassen}
    if (Settings.HttpFirewall<>chbWinFirewall.Checked) then begin
      Settings.HttpFirewall:=chbWinFirewall.Checked;
      ChangeFirewallState(Settings.HttpFirewall);
    end;
    if (Settings.HttpUPnP<>chbUPNP.Checked) then begin
      Settings.HttpUPnP:=chbUPNP.Checked;
      ChangeUPnPState(Settings.HttpUPnP);
    end;

    if (Settings.SmtpServerPort<>StrToInt(edtSMTPServerPort.Text)) then begin
      Settings.SmtpServerPort:=StrToInt(edtSMTPServerPort.Text);
      PHPIni.ChangeSetting('smtp_port',IntToStr(Settings.SmtpServerPort));
      PHPIni.Save();
      phpchanged:=true;
      if (chbSMTPActive.Checked) then begin
        ServerActive:=false;
        Settings.SmtpActive:=chbSMTPActive.Checked;
        ServerActive:=true;
      end;
    end;

    if (Settings.SmtpActive<>chbSMTPActive.Checked) then begin
      ServerActive:=false;
      Settings.SmtpActive:=chbSMTPActive.Checked;
      ServerActive:=true;
    end;
  end;

  if (Settings.PHPMaxUpload<>UpDown1.Position) then begin
    Settings.PHPMaxUpload:=UpDown1.Position;
    phpini.ChangeSetting('upload_max_filesize',IntToStr(Settings.PHPMaxUpload)+'M');
    phpini.ChangeSetting('post_max_size',IntToStr(Settings.PHPMaxUpload)+'M');
    phpini.ChangeSetting('memory_limit',IntToStr(Settings.PHPMaxUpload)+'M');
    phpini.Save();
    phpchanged:=true;
  end;

  if (Settings.Language<>cbxLanguage.Text) then begin
    if cbxLanguage.ItemIndex=0 then
      Settings.Language:=''
    else
      Settings.Language:=cbxLanguage.Text;
    UpdateCaptions();
  end;

  if phpchanged then
    ShowMessage(lang.Translate(statRestart));

  Settings.AutoStart:=chbAutoStart.Checked;
  Settings.CheckForUpdates:=chbUpdates.Checked;

  Settings.eyeOS_PreferUpdate:=chbPreferUpdate.Checked;

  Settings.Save();

  CoolTrayIcon1.HideMainForm();
end;
{-------------------------------------------------------------------------------}
procedure TfmMain.IdHTTPServer2CreatePostStream(AContext: TIdContext;
  AHeaders: TIdHeaderList; var VPostStream: TStream);
begin
  {TODO: Abhngig von Content-Length Temp-File benutzen}
  VPostStream:=TMemoryStream.Create();
end;
{-------------------------------------------------------------------------------}
procedure TfmMain.FormDestroy(Sender: TObject);
begin
  ChangeUPnPState(false);
  phpini.Free();
  firewall.Free();
  lang.Free();
  Settings.Save();
end;
{-------------------------------------------------------------------------------}
procedure TfmMain.IdSMTPServer1RcptTo(ASender: TIdSMTPServerContext;
  const AAddress: string; AParams : TIdStrings; var VAction: TIdRCPToReply; var VForward: string);
begin
  {TODO: Adresse prfen}
  if (Pos('@',AAddress)>0) then
    VAction:=rAddressOk
  else
    VAction:=rInvalid;
end;
{-------------------------------------------------------------------------------}
procedure TfmMain.IdSMTPServer1Connect(AContext: TIdContext);
begin
  if AContext.Binding.PeerIP<>'127.0.0.1' then
    AContext.Connection.Disconnect;
end;
{-------------------------------------------------------------------------------}
procedure TfmMain.IdSMTPServer1MailFrom(ASender: TIdSMTPServerContext;
  const AAddress: string; AParams : TIdStrings; var VAction: TIdMailFromReply);
begin
  VAction:=mAccept;
end;
{-------------------------------------------------------------------------------}
function SortServers(List: TStringList; Index1, Index2: Integer): Integer;
begin
  Result := Integer(List.Objects[Index2]) - Integer(List.Objects[Index1]);
end;
{-------------------------------------------------------------------------------}
procedure TfmMain.IdSMTPServer1MsgReceive(ASender: TIdSMTPServerContext;
  AMsg: TStream; var LAction: TIdDataReply);
var      Servers : TStringList;
         I       : Integer;
         idSMTP1 : TidSMTP;
         DNSResolve : TIdDNSResolver;

         Message    : TIdMessage;
         sent       : Boolean;
begin
  Message:=TIdMessage.Create();
  idSMTP1:=TIdSMTP.Create();
  idSMTP1.MailAgent:='eyeOS MicroServer';
  sent:=false;

  try
    Message.NoDecode := True;
    Message.LoadFromStream(AMsg);

    if not Settings.SmtpNeverDirect then begin
      DNSResolve:=TIdDNSResolver.Create();
      Servers := TStringList.Create;
      try
        DNSResolve.AllowRecursiveQueries:=true;
        DNSResolve.Host:=GetDNS;
        DNSResolve.IPVersion:=Id_IPv4;
        DNSResolve.QueryType:=[qtMX];

        while (DNSResolve.Host<>'') and (Servers.Count=0) do begin
          DNSResolve.Resolve(Message.Recipients[0].Domain);
          DNSResolve.Host:='';
          for I := 0 to DNSResolve.QueryResult.Count-1 do begin
            if DNSResolve.QueryResult[i] is TMXRecord then begin
              with TMXRecord(DNSResolve.QueryResult[i]) do
                Servers.AddObject(ExchangeServer,TObject(Integer(Preference)));
            end else if DNSResolve.QueryResult[i] is TNSRecord then begin
              DNSResolve.Host:=TNSRecord(DNSResolve.QueryResult[i]).HostName;
              break;
            end;
          end;
        end;

        Servers.CustomSort(SortServers);
        sent:=false;
        for I := 0 to Servers.Count-1 do begin
          try
            idSMTP1.Disconnect;
            idSMTP1.Connect(Servers.Strings[I],25);
            idSMTP1.Send(Message);
            sent:=true;
            break;
          except
            on E : EIdSMTPReplyError do
              break; {Mail wurde abgeleht, nicht bei den restlichen Servern probieren}
          end;
        end;

      finally
        Servers.Free;
        DNSResolve.Free();
      end;
    end;

    if not sent then begin
      if (Settings.SmtpHost<>'') then begin
        idSMTP1.Disconnect();
        idSMTP1.Host:=Settings.SmtpHost;
        idSMTP1.Username:=Settings.SmtpUsername;
        idSMTP1.Password:=Settings.SmtpPassword;
        idSMTP1.AuthType:=atDefault;
        try
          idSMTP1.Connect();
          idSMTP1.Send(Message);
        except
        end;
      end;
    end;

  finally
    idSMTP1.Free();
    Message.Free();
  end;
end;
{-------------------------------------------------------------------------------}
procedure TfmMain.DoTrigger;
begin
  if (ServerActive) then
    miOpenInDefaultBrowserClick(nil);
end;
{-------------------------------------------------------------------------------}
procedure TfmMain.ChangeFirewallState(Open: Boolean);
begin
  try
    if (firewall.Enabled) then begin
      if Open then begin
        if Settings.HttpFirewall then begin
          if (not firewall.AppIsEnabled(ParamStr(0))) then begin
            firewall.AddApp(ParamStr(0),'eyeOS MicroServer');
            RichEdit1.Lines.Add(lang.Translate(statFirewallOpened))
          end else
            RichEdit1.Lines.Add(lang.Translate(statFirewallAlreadyOpen));
        end;
      end else begin
        {Port lschen}
        firewall.RollBack();
        RichEdit1.Lines.Add(lang.Translate(statServerRemoved));
      end;
    end;
  except end;
end;
{-------------------------------------------------------------------------------}
procedure TfmMain.ChangeUPnPState(Mapped: Boolean);
begin
  if Mapped then begin
    if firewall.Enabled and (not firewall.PortIsEnabled(2869,NET_FW_IP_PROTOCOL_TCP)
       or not firewall.PortIsEnabled(1900,NET_FW_IP_PROTOCOL_UDP)) then begin
      {UPnP-Ports sind nicht offen}
      RichEdit1.Lines.Add(lang.Translate(errUPnPClosedInFW));
      exit;
    end;

    upnpset:=false;
    if not UPnPSet then begin
      if AddMapping(Settings.HttpPort,'TCP',Settings.HttpPort,true,'eyeOS MicroServer') then begin
        UPnPSet:=true;
        RichEdit1.Lines.Add(lang.Translate(statUPnPSet));
      end else
        RichEdit1.Lines.Add(lang.Translate(errUPnPSet));
    end;
  end else begin
    {Mapping entfernen, wenn es zuvor gestetzt wurde}
    if UPnPSet then begin

      if firewall.Enabled and (not firewall.PortIsEnabled(2869,NET_FW_IP_PROTOCOL_TCP)
         or not firewall.PortIsEnabled(1900,NET_FW_IP_PROTOCOL_UDP)) then begin
        {UPnP-Ports sind nicht offen}
        RichEdit1.Lines.Add('UPnP ports closed in Windows firewall');
        exit;
      end;

      if RemoveMapping(Settings.HttpPort,'TCP') then
        RichEdit1.Lines.Add(lang.Translate(statUPnPRemoved))
      else
        RichEdit1.Lines.Add(lang.Translate(errUPnPRemove));
      UPnPSet:=false;
    end;
  end;
end;
{-------------------------------------------------------------------------------}
procedure TfmMain.ReStartHttpServer;
var       sslhandler : TIdServerIOHandlerSSLOpenSSL;
begin
  if (HttpServer<>nil) then begin
    if HttpServer.IOHandler is TIdServerIOHandlerSSLOpenSSL then
      HttpServer.IOHandler.Free();
    FreeAndNil(HttpServer);
  end;
  HttpServer:=TIdHTTPServer.Create(self);
  PHPRunner.Server:=HttpServer;
  HttpServer.DefaultPort:=Settings.HttpPort;
  HttpServer.OnCommandGet:=IdHTTPServer2CommandGet;
  HttpServer.OnConnect:=IdHTTPServer1Connect;
  if (Settings.UseTLS) then begin
    sslhandler:=nil;
    try
      sslhandler:=TIdServerIOHandlerSSLOpenSSL.Create();
      sslhandler.OnGetPassword:=GetCertPW;
      sslhandler.SSLOptions.Method:=sslvTLSv1;
      sslhandler.SSLOptions.Mode:=sslmServer;
      sslhandler.SSLOptions.RootCertFile:=Settings.TLS_CertFile;
      sslhandler.SSLOptions.CertFile:=Settings.TLS_CertFile;
      sslhandler.SSLOptions.KeyFile:=Settings.TLS_KeyFile;
      sslhandler.SSLOptions.VerifyMode:=[sslvrfClientOnce];
      HttpServer.IOHandler:=sslhandler;
    except
      on E : Exception do begin
        RichEdit1.Lines.Add(E.Message);
        Settings.UseTLS:=false;
        sslhandler.Free();
      end;
    end;
  end;
  HttpServer.Active:=true;
  RichEdit1.Lines.Add(Format(lang.Translate(statServerStarted),[Settings.HttpPort]));
end;
{-------------------------------------------------------------------------------}
procedure TfmMain.ReStartSMTPServer;
begin
  if (SmtpServer<>nil) then
    FreeAndNil(SmtpServer);
  SmtpServer:=TIdSMTPServer.Create(self);
  SmtpServer.ServerName:='eyeOS MicroServer';
  SmtpServer.OnConnect:=IdSMTPServer1Connect;
  SmtpServer.OnMailFrom:=IdSMTPServer1MailFrom;
  SmtpServer.OnMsgReceive:=IdSMTPServer1MsgReceive;
  SmtpServer.OnRcptTo:=IdSMTPServer1RcptTo;
  SmtpServer.DefaultPort:=Settings.SmtpServerPort;

  SmtpServer.Active:=true;
  RichEdit1.Lines.Add(lang.Translate(statSMTPStarted))
end;
{-------------------------------------------------------------------------------}
procedure TfmMain.btnCancelClick(Sender: TObject);
begin
  CoolTrayIcon1.HideMainForm();
end;
{-------------------------------------------------------------------------------}
procedure TfmMain.IdHTTPServer1Connect(AContext: TIdContext);
begin
  case Settings.HTTPIPRanges of
    1 : begin
          if (IPv4ToDWord(AContext.Binding.PeerIP) xor IPv4ToDWord(AContext.Binding.IP)) > High(Byte) then
            AContext.Binding.CloseSocket();
        end;
    2 : begin
          if AContext.Binding.PeerIP<>'127.0.0.1' then
            AContext.Binding.CloseSocket();
        end;
  end;
end;
{-------------------------------------------------------------------------------}
procedure TfmMain.CreateParams(var Params: TCreateParams);
begin
  inherited;
   with Params.WindowClass do
    Style := Style or CS_NOCLOSE;
end;
{-------------------------------------------------------------------------------}
procedure TfmMain.UpdateSettingControls;
var       i : Integer;
begin
  chbUPNP.Checked:=Settings.HttpUPnP;
  edtServerPort.Text:=IntToStr(Settings.HttpPort);
  chbWinFirewall.Checked:=Settings.HttpFirewall;
  edtSMTPHost.Text:=Settings.SmtpHost;
  edtUsername.Text:=Settings.SmtpUsername;
  edtPassword.Text:=Settings.SmtpPassword;
  chbNeverDirectMail.Checked:=Settings.SmtpNeverDirect;
  chbSMTPActive.Checked:=Settings.SmtpActive;
  UpdateSMTPPage();
  edtSMTPServerPort.Text:=IntToStr(Settings.SmtpServerPort);
  UpDown1.Position:=Settings.PHPMaxUpload;
  rgpIPRanges.ItemIndex:=Settings.HTTPIPRanges;
  chbZLib.Checked:=Settings.HttpZLib;

  chbEnableTLS.Checked:=Settings.UseTLS;
  chbEnableTLS.Enabled:=Settings.OpenSSLAvailable;
  btnConfigTLS.Enabled:=Settings.OpenSSLAvailable;
  fmConfigTLS.edtCertFile.Text:=Settings.TLS_CertFile;
  fmConfigTLS.edtKeyFile.Text:=Settings.TLS_KeyFile;
  fmConfigTLS.edtPassword.Text:=Settings.TLS_KeyPassword;
  fmConfigTLS.chbSavePassword.Checked:=Settings.TLS_SavePassword;

  chbAutoStart.Checked:=Settings.AutoStart;
  if Settings.IsOnRemovableDrive then
    chbAutoStart.Enabled:=false;

  cbxLanguage.Items.Clear();
  cbxLanguage.Items.Add('English (Default)');
  for i:=0 to lang.Count-1 do begin
    cbxLanguage.Items.Add(lang.Languages[i]);
  end;
  if Settings.Language='' then
    cbxLanguage.Text:='English (Default)'
  else
    cbxLanguage.Text:=Settings.Language;

  chbUpdates.Checked:=Settings.CheckForUpdates;

  chbPreferUpdate.Checked:=Settings.eyeOS_PreferUpdate;
end;
{-------------------------------------------------------------------------------}
function TfmMain.GetDNS: String;
const
  NTdyn = 'System\CurrentControlSet\Services\Tcpip\Parameters\Temporary';
  NTfix = 'System\CurrentControlSet\Services\Tcpip\Parameters';
  W9xfix = 'System\CurrentControlSet\Services\MSTCP';
begin
  Result := GetDNSbyIpHlp;
  if Result = '...' then
    if Win32Platform = VER_PLATFORM_WIN32_NT then
    begin
      Result := ReadReg(NTdyn, 'NameServer');
      if result = '' then
        Result := ReadReg(NTfix, 'NameServer');
    end
    else
      Result := ReadReg(W9xfix, 'NameServer');

  if (Pos(',',Result)>0) then begin
    Result:=Copy(Result,1,Pos(',',Result)-1);
  end;
end;
{-------------------------------------------------------------------------------}
procedure TfmMain.Label3Click(Sender: TObject);
begin
  Shellexecute(0,'open','http://www.indyproject.org','','',0);
end;
{-------------------------------------------------------------------------------}
procedure TfmMain.Label6Click(Sender: TObject);
begin
  Shellexecute(0,'open','http://members.chello.be/ws36637/php4delphi.html','','',0);
end;
{-------------------------------------------------------------------------------}
procedure TfmMain.Label7Click(Sender: TObject);
begin
  Shellexecute(0,'open','http://subsimple.com/delphi.asp','','',0);
end;
{-------------------------------------------------------------------------------}
procedure TfmMain.Label8Click(Sender: TObject);
begin
  Shellexecute(0,'open','http://www.madshi.net','','',0);
end;
{-------------------------------------------------------------------------------}
procedure TfmMain.Label10Click(Sender: TObject);
begin
  Shellexecute(0,'open','http://www.php.net/software/','','',0);
end;
{-------------------------------------------------------------------------------}
procedure TfmMain.lblEyeOSHomeClick(Sender: TObject);
begin
  Shellexecute(0,'open','http://www.eyeos.org','','',0);
end;
{-------------------------------------------------------------------------------}
procedure TfmMain.UpdateCaptions;
begin
  lang.Selected:=Settings.Language;
  if (lang.Selected<>Settings.Language) then
    Settings.Language:=lang.Selected;

  btnOK.Caption:=lang.Translate(capBtnOK);
  btnCancel.Caption:=lang.Translate(capBtnCancel);

  tshMisc.Caption:=lang.Translate(capTshMisc);
  gbxGeneral.Caption:=lang.Translate(capGbxGeneral);
  gbxLanguage.Caption:=lang.Translate(capLblLanguage);
  chbAutoStart.Caption:=lang.Translate(capChbAutoStart);
  gbxPHP.Caption:=lang.Translate(capGbxPHP);
  edtMaxUpload.EditLabel.Caption:=lang.Translate(capEdtMaxUpload);

  tshServer.Caption:=lang.Translate(capTshServer);
  gbxPortSettings.Caption:=lang.Translate(capGbxPortSettings);
    
  edtServerPort.EditLabel.Caption:=lang.Translate(capEdtServerPort);
  chbWinFirewall.Caption:=lang.Translate(capChbWinFirewall);
  chbUPNP.Caption:=lang.Translate(capChbUPNP);
  rgpIPRanges.Caption:=lang.Translate(capRgpIPRanges);
  rgpIPRanges.Items[0]:=lang.Translate(capRgpIPRanges_item0);
  rgpIPRanges.Items[1]:=lang.Translate(capRgpIPRanges_Item1);
  rgpIPRanges.Items[2]:=lang.Translate(capRgpIPRanges_Item2);
  gbxMiscServerSettings.Caption:=lang.Translate(capGbxMiscServerSettings);
  chbZLib.Caption:=lang.Translate(capChbZLib);

  tshSMTP.Caption:=lang.Translate(capTshSMTP);
  lblSMTP.Caption:=lang.Translate(capLblSMTP1)+' '+lang.Translate(capLblSMTP2);
  chbSMTPActive.Caption:=lang.Translate(capChbSMTPActive);
  edtSMTPServerPort.EditLabel.Caption:=lang.Translate(capEdtSMTPServerPort);
    edtSMTPServerPort.Left:=edtSMTPServerPort.EditLabel.Width+8+edtSMTPServerPort.LabelSpacing;

  gbxExternalSMPT.Caption:=lang.Translate(capGbxExternalSMTP);
  chbNeverDirectMail.Caption:=lang.Translate(capChbNeverDirectMal);
  edtSMTPHost.EditLabel.Caption:=lang.Translate(capEdtSMTPHost);
  edtUsername.EditLabel.Caption:=lang.Translate(capEdtUsername);
  edtPassword.EditLabel.Caption:=lang.Translate(capEdtPassword);

  tshAbout.Caption:=lang.Translate(capTshAbout);
  lblVersion.Caption:=lang.Translate(capLblVersion)+' '+rsVersion;
  lblDevBy.Caption:=lang.Translate(capLBLDevBy)+' Bjrn Ahrens';
  lblEyeOSHome.Caption:=lang.Translate(capLblEyeOsHome);;
  gbxInfo.Caption:=lang.Translate(capGbxInfo);
  lblComponents.Caption:=lang.Translate(capLblComponents);

  tshLog.Caption:=lang.Translate(capTshLog);

  miOpenInDefaultBrowser.Caption:=lang.Translate(capShow2);
  Exit1.Caption:=lang.Translate(capExit1);
  Settings1.Caption:=lang.Translate(capSettings1);

  chbUpdates.Caption:=lang.Translate(capChbUpdates);
  btnUpdates.Caption:=lang.Translate(capBtnUpdates);
    btnUpdates.Width:=Canvas.TextWidth(lang.Translate(capBtnUpdates))+10;
    btnUpdates.Left:=(tshMisc.Width-btnUpdates.Width) div 2;
  miServerActive.Caption:=lang.Translate(capMiServerActive);

  chbEnableTLS.Caption:=lang.Translate(capChbEnableTLS);
  lblOpenSSL.Caption:=lang.Translate(capLblOpenSSL);
  lblOpenSSLDownload.Caption:=lang.Translate(capLblOpenSSLDownload);
  btnConfigTLS.Caption:=lang.Translate(capBtnTLSConfig);

  gbxEyeOs.Caption:=lang.Translate(capGbxEyeOS);
  chbPreferUpdate.Caption:=lang.Translate(capChbPreferUpdate);
end;
{-------------------------------------------------------------------------------}
procedure TfmMain.btnUpdatesClick(Sender: TObject);
begin
  CheckForUpdate(true);
end;
{-------------------------------------------------------------------------------}
procedure TfmMain.CheckForUpdate(Popup: Boolean);
var       http     : TIdHttp;
          sVersion : String;
begin
  http:=TIdHTTP.Create();
  try
    try
      sVersion:=Trim(http.Get('http://eyeos.org/download/microserverversion.txt'));
      if (sVersion<>rsVersion) then begin
        if Application.MessageBox(PChar(lang.Translate(txtNewVersion)
                +#13#10+Format(lang.Translate(txtVersionDiff),[rsVersion,sVersion])
                +#13#10+lang.Translate(txtDownloadVersion))
               ,PChar(lang.Translate(capNewVersion)),MB_YESNO or MB_ICONINFORMATION) = ID_YES then
          Shellexecute(0,'open','http://eyeos.org/download/setupMicroServer.exe','','',0);
      end else if (Popup) then
        ShowMessage(lang.Translate(txtMostRecentVersion));
    except
      on E : EIdSocketError do begin
        case E.LastError of
          11001 : begin
                    if (Popup) then
                      MessageDlg(lang.Translate(errUpdateSocketError),mtError,[mbOK],0);

                    RichEdit1.Lines.Add(lang.Translate(errUpdateSocketError));
                  end;
          else begin
            if (Popup) then
              ShowMessage(E.Message);
            RichEdit1.Lines.Add('Updatecheck: '+E.Message);
          end;
        end;
      end;
      on E : Exception do
        RichEdit1.Lines.Add('Updatecheck: '+E.Message);
    end;
  finally
    http.Free();
  end;
end;
{-------------------------------------------------------------------------------}
procedure TfmMain.SetServerActive(const Value: Boolean);
begin
  if (Value<>FActive) then begin
    if (Value) then begin
      try
        ReStartHttpServer();
      except
        on EIdCouldNotBindSocket do begin
          ShowMessage(Format(lang.Translate(txtServerPortInUse),[Settings.HttpPort]));
          exit;
        end;
      end;
      if Settings.SmtpActive then
        try
          ReStartSMTPServer();
        except
          on EIdCouldNotBindSocket do begin
            ShowMessage (Format(lang.Translate(txtSMTPPortInUse),[Settings.SmtpServerPort]));
            Settings.SmtpActive:=false;
            UpdateSettingControls();
          end;
        end;
      CoolTrayIcon1.IconIndex:=1;
    end else begin
      StopServers();
      CoolTrayIcon1.IconIndex:=0;
    end;
    miServerActive.Checked:=Value;
    FActive := Value;
  end;
end;
{-------------------------------------------------------------------------------}
procedure TfmMain.StopServers;
begin
  if (HttpServer<>nil) then begin
    FreeAndNil(HttpServer);
    RichEdit1.Lines.Add(lang.Translate(statServerStopped));
  end;
  if (SmtpServer<>nil) then begin
    FreeAndNil(SmtpServer);
    RichEdit1.Lines.Add(lang.Translate(statSMTPStopped));
  end;
end;
{-------------------------------------------------------------------------------}
procedure TfmMain.miServerActiveClick(Sender: TObject);
begin
  ServerActive:=not ServerActive;
end;
{-------------------------------------------------------------------------------}
procedure TfmMain.UpdateSMTPPage;
begin
  gbxExternalSMPT.Enabled:=chbSMTPActive.Checked;
  chbNeverDirectMail.Enabled:=chbSMTPActive.Checked;
  edtSMTPServerPort.Enabled:=chbSMTPActive.Checked;
  edtSMTPHost.Enabled:=chbSMTPActive.Checked;
  edtUsername.Enabled:=chbSMTPActive.Checked;
  edtPassword.Enabled:=chbSMTPActive.Checked;
end;
{-------------------------------------------------------------------------------}
procedure TfmMain.chbSMTPActiveClick(Sender: TObject);
begin
  UpdateSMTPPage();
end;
{-------------------------------------------------------------------------------}
procedure TfmMain.GetCertPW(var Password: String);
begin
  password:=Settings.TLS_KeyPassword;
end;
{-------------------------------------------------------------------------------}
procedure TfmMain.lblOpenSSLDownloadClick(Sender: TObject);
begin
  Shellexecute(0,'open','http://www.slproweb.com/products/Win32OpenSSL.html','','',0);
end;
{-------------------------------------------------------------------------------}
procedure TfmMain.btnConfigTLSClick(Sender: TObject);
begin
  fmConfigTLS.ShowModal();
end;
{-------------------------------------------------------------------------------}
procedure TfmMain.FormShow(Sender: TObject);
begin
  if not Initialized then begin
    UpdateSettingControls();
    Initialized:=true;
  end;
end;

end.
