{*******************************************************}
{       This unit is part of eyeOS microserver          }
{                                                       }
{ Author:                                               }
{ Bjrn Ahrens                                          }
{ bjoern@ahrens.net                                     }
{ http://bjoern.ahrens.net                              }
{*******************************************************}

unit PHPInis;

interface

uses classes;

type
  TPHPIni = class
  private
    FStrings : TStringList;
    FIniFilename : String;
  public
    constructor Create (AIniFilename : String);
    destructor Destroy (); override;

    procedure ChangeSetting(Name, Value : String);
    procedure Save ();
  end;

implementation

uses SysUtils;

{ TPHPIni }

procedure TPHPIni.ChangeSetting(Name, Value: String);
var       i : Integer;
          s : String;
          j : Integer;
begin
  for i:=0 to FStrings.Count-1 do begin
    if Trim(FStrings[i])='' then continue;
    if FStrings[i][1]=';' then continue;

    s:=TrimLeft(FStrings[i]);
    if Copy(s,1,Length(Name))=Name then begin
      j:=Length(Name)+1;
      while (j<=Length(s)) and (s[j] in [#32,#9]) do
        INC(j);

      if (j>Length(s)) or (s[j]<>'=') then
        continue;

      FStrings[i]:=Name+'='+Value;
    end;
  end;
end;

constructor TPHPIni.Create(AIniFilename: String);
begin
  FIniFilename:=AIniFilename;
  FStrings:=TStringList.Create();
  FStrings.LoadFromFile(FIniFileName);
end;

destructor TPHPIni.Destroy;
begin
  FStrings.SaveToFile(FIniFileName);
  FStrings.Free();
  inherited;
end;

procedure TPHPIni.Save;
begin
  FStrings.SaveToFile(FIniFilename);
end;

end.
