; Script generated by the Inno Setup Script Wizard.
; SEE THE DOCUMENTATION FOR DETAILS ON CREATING INNO SETUP SCRIPT FILES!

#define MyAppName "eyeOS Microserver"
#define MyAppVerName "eyeOS Microserver 0.6"
#define MyAppPublisher "Bjrn Ahrens"
#define MyAppExeName "EyeOSMicroServer.exe"

[Setup]
AppName={#MyAppName}
AppVerName={#MyAppVerName}
AppPublisher={#MyAppPublisher}
DefaultDirName={pf}\{#MyAppName}
DefaultGroupName={#MyAppName}
AllowNoIcons=true
OutputDir=D:\Coding\EyeOSMicroServer\bin\Installer
OutputBaseFilename=setupMicroserver
SetupIconFile=D:\Coding\EyeOSMicroServer\eyeos.ico
Compression=lzma/ultra
SolidCompression=true
VersionInfoVersion=0.6.2
VersionInfoCompany=Bjrn Ahrens
ShowLanguageDialog=yes
LicenseFile=D:\Coding\EyeOsMicroServer\bin\Installer\license.txt
InternalCompressLevel=ultra

[Languages]
Name: en; MessagesFile: compiler:Default.isl
Name: de; MessagesFile: compiler:Languages\German.isl; LicenseFile: D:\Coding\EyeOSMicroServer\bin\Installer\de_license.txt
Name: fr; MessagesFile: compiler:Languages\French.isl

[Tasks]
Name: firewall; Description: {cm:option_Firewall}; GroupDescription: {cm:group_ServerOptions}; Flags: unchecked
Name: upnp; Description: {cm:option_Upnp}; GroupDescription: {cm:group_ServerOptions}; Flags: unchecked
Name: startup; Description: {cm:option_Startup}; Components: ; Languages: ; Flags: unchecked; GroupDescription: {cm:group_ServerOptions}; OnlyBelowVersion: 0,6
Name: desktopicon; Description: {cm:CreateDesktopIcon}; GroupDescription: {cm:AdditionalIcons}; Flags: unchecked
Name: quicklaunchicon; Description: {cm:CreateQuickLaunchIcon}; GroupDescription: {cm:AdditionalIcons}; Flags: unchecked


[Files]
Source: D:\Coding\EyeOSMicroServer\bin\EyeOSMicroServer.exe; DestDir: {app}; Flags: ignoreversion; Components: microserver
Source: D:\Coding\EyeOSMicroServer\bin\php5ts.dll; DestDir: {app}; Flags: ignoreversion; Components: microserver
Source: D:\Coding\EyeOSMicroServer\bin\php.ini; DestDir: {app}; Flags: ignoreversion; Components: microserver
Source: ..\eyeOS\*; DestDir: {app}\eyeOS; Flags: ignoreversion recursesubdirs createallsubdirs; Components: eyeOS\New
Source: ..\Upgrade\*; DestDir: {app}\eyeOS; Flags: ignoreversion recursesubdirs createallsubdirs; Components: eyeOS\Upgrade
; NOTE: Don't use "Flags: ignoreversion" on any shared system files
Source: changelog.txt; DestDir: {app}; Flags: ignoreversion
Source: ..\german.lng; DestDir: {app}
Source: ..\french.lng; DestDir: {app}

[Icons]
Name: {group}\{#MyAppName}; Filename: {app}\{#MyAppExeName}
Name: {group}\{cm:UninstallProgram,{#MyAppName}}; Filename: {uninstallexe}
Name: {userdesktop}\{#MyAppName}; Filename: {app}\{#MyAppExeName}; Tasks: desktopicon
Name: {userappdata}\Microsoft\Internet Explorer\Quick Launch\{#MyAppName}; Filename: {app}\{#MyAppExeName}; Tasks: quicklaunchicon

[Run]
Filename: {app}\{#MyAppExeName}; Description: {cm:LaunchProgram,{#MyAppName}}; OnlyBelowVersion: 0,6; Flags: nowait postinstall skipifsilent

[UninstallDelete]
Name: {app}\settings.ini; Type: files
Name: {app}\eyeOS; Type: filesandordirs
Name: {app}; Type: dirifempty

[INI]
Filename: {app}\settings.ini; Section: server; Key: upnp; String: 1; Flags: createkeyifdoesntexist; Tasks: upnp
Filename: {app}\settings.ini; Section: server; Key: winfirewall; String: 1; Flags: createkeyifdoesntexist; Tasks: firewall
Filename: {app}\settings.ini; Section: misc; Key: language; String: {code:IniLanguage|{language}}

[Components]
Name: microserver; Description: {cm:component_Server}; Types: full custom compact; Flags: fixed
Name: eyeOS; Description: {cm:component_eyeOS}; Types: full
Name: eyeOS\Upgrade; Description: {cm:component_eyeOSUpgrade}; Types: full; Flags: exclusive
Name: eyeOS\New; Description: {cm:component_eyeOSNew}; Types: full; Flags: exclusive

[Registry]
Root: HKCU; Subkey: Software\Microsoft\Windows\CurrentVersion\Run; ValueType: string; ValueName: eyeOS MicroServer; Flags: uninsdeletevalue createvalueifdoesntexist; Components: microserver; Tasks: " startup"; ValueData: {app}\EyeOSMicroServer.exe; OnlyBelowVersion: 0,6

[CustomMessages]
group_ServerOptions=Server options
option_Firewall=Open Microserver in Windows firewall
option_Upnp=Create UPnP mapping for Microserver HTTP port
option_Startup=Start Microserver when Windows starts
component_Server=Microserver executable and PHP
component_eyeOS=eyeOS files
component_eyeOSNew=new eyeOS 1.1.0.1 installation
component_eyeOSUpgrade=update from eyeOS 1.x to 1.1.0.1
de.group_ServerOptions=Server-Einstellungen
de.option_Firewall=Microserver in Windows-Firewall freigeben
de.option_Upnp=UPnP-Weiterleitung fr Microserver einrichten
de.option_Startup=Microserver bim Windows-Start starten
de.component_Server=Microserver Programmdatei und PHP
de.component_eyeOS=eyeOS-Dateien
de.component_eyeOSNew=neue eyeOS 1.1.0.1 Installation
de.component_eyeOSUpgrade=Update von eyeOS 1.x zu 1.1.0.1
fr.group_ServerOptions=Options du serveur
fr.option_Firewall=Ouvrir Microserveur dans le pare-feu Windows
fr.option_Upnp=Crer un mappage UPnP pour les ports HTTP du Microserveur
fr.option_Startup=Dmarrer Microserveur avec Windows
fr.component_Server=Executable Microserveur et PHP
fr.component_eyeOS=Fichiers eyeOS

[Code]
function IniLanguage (InstLang : String) : String;
begin
  Result:='';
  if (InstLang='de') then
    Result:='Deutsch'
  else if (InstLang='fe') then
    Result:='Franais';
end;
