﻿var XDocView = {
	project		: {
		path : '',
		file : '',
		unitnames : new Array(),
		unitfiles : new Array()
	},
	projectXSL	: loadXSL("doc/xsl/doc-project.xsl"),
	unitXSL		: loadXSL("doc/xsl/doc.xsl"),

	unitSourceLoaded : false,
	currentUnitFile  : ''	// full path including file name, excluding file extension to currently displayed pascal unit
};

/*---------------------------------------------------------------------*/

function loadXSL (fileName) {
	if (location.protocol=="file:") {
		// Lokal funktioniert xmlHttpRequest nicht mit IE - in diesem Fall XMLDOM benutzen
		var xmlDom = null;
		try {
			// MS Internet Explorer (ab v6)
			xmlDom=new ActiveXObject("Microsoft.XMLDOM");
		} catch(e) {
			try {
				// MS Internet Explorer (ab v5)
				xmlDom=new ActiveXObject("MSXML2.XMLDOM");
			} catch(e) {
				xmlDom=null;
			}
		}
			
		if (xmlDom) {
			xmlDom.async = false;
			xmlDom.validateOnParse = false;
			xmlDom.load(fileName);
			
			if (xmlCheckAndDisplayError(xmlDom)) {
				return null;
			} else {
				return xmlDom;
			}
		}
	}   

	// Nicht lokal (oder nicht IE), dann xmlHttpRequest benutzen
	var xmlHttp = null;
	try {
		// Mozilla, Opera, Safari sowie Internet Explorer (ab v7)
		xmlHttp = new XMLHttpRequest();
	} catch(e) {
		try {
			// MS Internet Explorer (ab v6)
			xmlHttp  = new ActiveXObject("Microsoft.XMLHTTP");
		} catch(e) {
			try {
				// MS Internet Explorer (ab v5)
				xmlHttp  = new ActiveXObject("Msxml2.XMLHTTP");
			} catch(e) {
				xmlHttp  = null;
			}
		}
	}
	if (xmlHttp) {
		xmlHttp.open('GET', fileName, false);
		xmlHttp.send(null);
	}
	
	if (xmlCheckAndDisplayError(xmlHttp.responseXML)) {
		return null;
	} else {
		return xmlHttp.responseXML;
	}
}

/*---------------------------------------------------------------------*/

function loadXMLData (data) {
	var xmlDom = null;

	if (window.DOMParser) {
		try {
			parser=new DOMParser();
			parser.preserverWhiteSpace=true;
			xmlDom=parser.parseFromString(data,"text/xml");
		} catch (e) {
			return null;
		}
	} else { // Internet Explorer (kleiner v9)
		try {
			// MS Internet Explorer (ab v6)
			xmlDom=new ActiveXObject("Microsoft.XMLDOM");
		} catch(e) {
			try {
				// MS Internet Explorer (ab v5)
				xmlDom=new ActiveXObject("MSXML2.XMLDOM");
			} catch(e) {
				xmlDom=null;
			}
		}
			
		if (xmlDom) {
			xmlDom.async = false;
			xmlDom.loadXML(data);
		}
	}
	
	if (xmlCheckAndDisplayError(xmlDom)) {
		return null;
	} else {
		return xmlDom;
	}
}

/*---------------------------------------------------------------------*/

/* found at http://www.tek-tips.com/viewthread.cfm?qid=1068264 */
String.prototype.asciiCodeAt = function(i) {
    // charCodeAt returns some bytes translated to unicode characters. 
    // this function means to counteract that.
    switch(this.charCodeAt(i)) {
        case 0x20AC: return 0x80; break;
        case 0x201A: return 0x82; break;
        case 0x0192: return 0x83; break;
        case 0x201E: return 0x84; break;
        case 0x2026: return 0x85; break;
        case 0x2020: return 0x86; break;
        case 0x2021: return 0x87; break;
        case 0x02C6: return 0x88; break;
        case 0x2030: return 0x89; break;
        case 0x0160: return 0x8A; break;
        case 0x2039: return 0x8B; break;
        case 0x0152: return 0x8C; break;
        case 0x017D: return 0x8E; break;
        case 0x2018: return 0x91; break;
        case 0x2019: return 0x92; break;
        case 0x201C: return 0x93; break;
        case 0x201D: return 0x94; break;
        case 0x2022: return 0x95; break;
        case 0x2013: return 0x96; break;
        case 0x2014: return 0x97; break;
        case 0x02DC: return 0x98; break;
        case 0x2122: return 0x99; break;
        case 0x0161: return 0x9A; break;
        case 0x203A: return 0x9B; break;
        case 0x0153: return 0x9C; break;
        case 0x017E: return 0x9E; break;
        case 0x0178: return 0x9F; break;
        default: return this.charCodeAt(i); break;
		
/*
var win2byte = {
  '\u20AC': '\x80', '\u201A': '\x82', '\u0192': '\x83', '\u201E': '\x84',
  '\u2026': '\x85', '\u2020': '\x86', '\u2021': '\x87', '\u02C6': '\x88',
  '\u2030': '\x89', '\u0160': '\x8A', '\u2039': '\x8B', '\u0152': '\x8C',
  '\u017D': '\x8E', '\u2018': '\x91', '\u2019': '\x92', '\u201C': '\x93',
  '\u201D': '\x94', '\u2022': '\x95', '\u2013': '\x96', '\u2014': '\x97',
  '\u02DC': '\x98', '\u2122': '\x99', '\u0161': '\x9A', '\u203A': '\x9B',
  '\u0153': '\x9C', '\u017E': '\x9E', '\u0178': '\x9F'
};


http://domnit.org/blog/2007/07/fix-encoding.html

*/
    }
}

function validateUTF8 (str) {
	str=str.split("");
	i=0;
	while (i<str.length) {
		c=str[i].asciiCodeAt(0);
		if (c>127) {
			if ((c & 192) == 192) {
				//1. Byte muss mit 11... beginnen
				if ((c & 224) == 192) {
					// 1. Byte = 110...? Dann nächstes Zeichen überprüfen
					if ((str[i+1].asciiCodeAt(0) & 192) == 128)
						i++;
					else
						str[i]='?';
				} else if ((c & 240) == 224)
					// 1. Byte = 1110...? Dann nächsten zwei Byte überprüfen
					if (((str[i+1].asciiCodeAt(0) & 192) == 128) && ((str[i+2].asciiCodeAt(0) & 192) == 128))
						i+=2;
					else
						str[i]='?';
				else {
					// 1. Byte beginnt mit 11, aber nicht mit 110 oder 1110 => als "ungültig" markieren
					str[i]='?';
				}
			} else
				str[i]='?';
		}
		i++;
	}
	return str.join("");
}


function utf8_decode (str_data) {
  // http://kevin.vanzonneveld.net
  // + original by: Webtoolkit.info (http://www.webtoolkit.info/)
  // + input by: Aman Gupta
  // + improved by: Kevin van Zonneveld (http://kevin.vanzonneveld.net)
  // + improved by: Norman "zEh" Fuchs
  // + bugfixed by: hitwork
  // + bugfixed by: Onno Marsman
  // + input by: Brett Zamir (http://brett-zamir.me)
  // + bugfixed by: Kevin van Zonneveld (http://kevin.vanzonneveld.net)
  // * example 1: utf8_decode('Kevin van Zonneveld');
  // * returns 1: 'Kevin van Zonneveld'
  var tmp_arr = [],
    i = 0,
    ac = 0,
    c1 = 0,
    c2 = 0,
    c3 = 0;

  str_data += '';

  while (i < str_data.length) {
    c1 = str_data.charCodeAt(i);
    if (c1 < 128) {
      tmp_arr[ac++] = String.fromCharCode(c1);
      i++;
    } else if (c1 > 191 && c1 < 224) {
      c2 = str_data.charCodeAt(i + 1);
      tmp_arr[ac++] = String.fromCharCode(((c1 & 31) << 6) | (c2 & 63));
      i += 2;
    } else {
      c2 = str_data.charCodeAt(i + 1);
      c3 = str_data.charCodeAt(i + 2);
      tmp_arr[ac++] = String.fromCharCode(((c1 & 15) << 12) | ((c2 & 63) << 6) | (c3 & 63));
      i += 3;
    }
  }

  return tmp_arr.join('');
}

/*---------------------------------------------------------------------*/

function loadXML (fileName) {
	text=loadTextFile (fileName);
	//bom = 0xef 0xbb 0xbf;

	if ((text.length>3) && (text.charCodeAt(0)==0xef) && (text.charCodeAt(1)==0xbb) && (text.charCodeAt(2)==0xbf))
		text = text.substr(3);
		
	text=validateUTF8(text);
	
	if (!$.browser.msie)
		text=utf8_decode( text );
	
	//$("#tab-debug").html('<pre>'+text.replace(/&/g,'&amp;').replace(/</g,'&lt;').replace(/>/g,'&gt;')+'</pre>');
	return loadXMLData (text);
}

/*---------------------------------------------------------------------*/

function loadTextFile (fileName) {
	var result='';
	if (window.ActiveXObject) {
		// Datei in IE über FileSystemObject öffnen, da overrideMimeType nicht unterstützt wird
		fs = new ActiveXObject("Scripting.FileSystemObject");
		file = fs.OpenTextFile(fileName,1); //FileMode 1 = forReading
		result = file.ReadAll();
		file = null;
		fs = null;
	} else {
		$.ajax({
			async : false,
			url: 'file:///'+fileName,
			dataType : 'text',
			beforeSend : function (xhr) {
				xhr.overrideMimeType("text/plain; charset=Windows-1252");
			}
		}).done(function(data){
				result=data;
		});
	}
	return result;
}

/*---------------------------------------------------------------------*/

var	projectunits = new Array();
var	projectfiles = new Array();

UTF8 = {
    encode: function(s){
        for(var c, i = -1, l = (s = s.split("")).length, o = String.fromCharCode; ++i < l;
            s[i] = (c = s[i].charCodeAt(0)) >= 127 ? o(0xc0 | (c >>> 6)) + o(0x80 | (c & 0x3f)) : s[i]
        );
        return s.join("");
    },
    decode: function(s){
        for(var a, b, i = -1, l = (s = s.split("")).length, o = String.fromCharCode, c = "charCodeAt"; ++i < l;
            ((a = s[i][c](0)) & 0x80) &&
            (s[i] = (a & 0xfc) == 0xc0 && ((b = s[i + 1][c](0)) & 0xc0) == 0x80 ?
            o(((a & 0x03) << 6) + (b & 0x3f)) : o(128), s[++i] = "")
        );
        return s.join("");
    }
};

/********************************************************
UI Elements
********************************************************/	

jQuery.expr[':'].Contains = function(a,i,m){
    return (a.textContent || a.innerText || "").toUpperCase().indexOf(m[3].toUpperCase())>=0;
};

function unitNotFoundDialog (unitname) {
	$('<div title="Unit not found" class="ui-state-error"><span class="ui-icon ui-icon-alert" style="float:left; margin:0 7px 50px 0;"></span>Unit "'+unitname+'" not found</div>').dialog({
			modal: true,
			buttons: {
				"Try DocuWiki" : function() {
						window.open("http://docwiki.embarcadero.com/VCL/en/"+unitname);
					},
				Ok: function() {
						$( this ).dialog( "close" );
					}
				}
			});
}

function xmlCheckAndDisplayError (xml) {
	if ((xml.parseError && xml.parseError.errorCode != 0) || (xml.documentElement.nodeName=="parsererror")) {
		var str = '<div title="Error loading XML" class="ui-state-error"><span class="ui-icon ui-icon-alert" style="float:left; margin:0 7px 50px 0;"></span>';

		if (xml.parseError) {
			// IE
			if (xml.parseError.errorCode != 0) {
				str+=("Error in line " + xml.parseError.line +
					" position " + xml.parseError.linePos +
					"<br/>Error Code: " + xml.parseError.errorCode +
					"<br/>Error Reason: " + xml.parseError.reason +
					"<br/>Error Line: " + xml.parseError.srcText);
			}
		} else {
			// FF etc.
			for (var i=0; i<xml.documentElement.childNodes.length; i++) {
				if (xml.documentElement.childNodes[i].nodeValue) {
					str+=xml.documentElement.childNodes[i].nodeValue.replace(/</g, "&lt;");
					str+='<br/>';
				}
			}
		}
	
		str+='</div>';
		$(str).dialog({
			modal: true,
			buttons: {
				Ok: function() {
						$( this ).dialog( "close" );
					}
				}
			});
		return true; //error
	}
	return false; //No error
}

jQuery.fn.expand_docheader = function () {
	$(this).next().show();
	$(this).children(".ui-icon").removeClass("ui-icon-triangle-1-e");
	$(this).children(".ui-icon").addClass("ui-icon-triangle-1-s");
	$(this).addClass("expanded");
};

jQuery.fn.collapse_docheader = function () {
	$(this).next().hide();
	$(this).children(".ui-icon").removeClass("ui-icon-triangle-1-s");
	$(this).children(".ui-icon").addClass("ui-icon-triangle-1-e");
	$(this).removeClass("expanded");
};

/********************************************************

********************************************************/

function findUnitFile (unitname) {
	for (i=0; i<projectunits.length; i++) {
		if (unitname==projectunits[i]) {
			return projectfiles[i];
		}
	}
	return null;
}

function loadXMLFile(dname) {
	if(location.protocol=="file:") {
		// Lokal funktioniert xmlHttpRequest nicht mit IE - in diesem Fall XMLDOM benutzen
		var xmlDom = null;
		try {
			// MS Internet Explorer (ab v6)
			xmlDom=new ActiveXObject("Microsoft.XMLDOM");
		} catch(e) {
			try {
				// MS Internet Explorer (ab v5)
				xmlDom=new ActiveXObject("MSXML2.XMLDOM");
			} catch(e) {
				xmlDom=null;
			}
		}
			
		if (xmlDom) {
			xmlDom.async = false;
			xmlDom.validateOnParse = false;
			xmlDom.load(dname);
			
			if (xmlCheckAndDisplayError(xmlDom)) {
				return null;
			} else {
				return xmlDom;
			}
		}
	}   

	// Nicht lokal (oder nicht IE), dann xmlHttpRequest benutzen
	var xmlHttp = null;
	try {
		// Mozilla, Opera, Safari sowie Internet Explorer (ab v7)
		xmlHttp = new XMLHttpRequest();
	} catch(e) {
		try {
			// MS Internet Explorer (ab v6)
			xmlHttp  = new ActiveXObject("Microsoft.XMLHTTP");
		} catch(e) {
			try {
				// MS Internet Explorer (ab v5)
				xmlHttp  = new ActiveXObject("Msxml2.XMLHTTP");
			} catch(e) {
				xmlHttp  = null;
			}
		}
	}
	if (xmlHttp) {
		xmlHttp.open('GET', dname, false);
		xmlHttp.send(null);
	}
	
	if (xmlCheckAndDisplayError(xmlHttp.responseXML)) {
		return null;
	} else {
		return xmlHttp.responseXML;
	}
}

function transformAndDisplayResult (xml, xsl, element) {
	// Transform of XML to HTML with browser detection (including IE9) copied from http://www.roelvanlisdonk.nl/?p=2113
	
	if (!xml || !xsl || !element) {
		return false;
	}
	
	$(element).empty();
	
	var result;
	
    // Use type XSLTProcessor, if browser (FF, Safari, Chrome etc) supports it
    if (typeof (XSLTProcessor) != "undefined") {
        var xsltProcessor = new XSLTProcessor();
        xsltProcessor.importStylesheet(xsl);
        result = xsltProcessor.transformToFragment(xml, document);
    }
    // Use function [transformNode] on the XmlDocument, if browser (IE6, IE7, IE8) supports it
    else if (typeof (xml.transformNode) != "undefined") {
        result = xml.transformNode(xsl);
    }
    else {
        try {
            // Use function transform on the XsltProcessor used for IE9 (which doesn't support [transformNode] any more)
            if (window.ActiveXObject) {
                var xslt = new ActiveXObject("Msxml2.XSLTemplate");
                var xslDoc = new ActiveXObject("Msxml2.FreeThreadedDOMDocument");
				xslDoc.preserveWhiteSpace=true;
                xslDoc.loadXML(xsl.xml);
                xslt.stylesheet = xslDoc;
                var xslProc = xslt.createProcessor();
                xslProc.input = xml;
                xslProc.transform();

                result = xslProc.output;
            }
        }
        catch (e) {
            // Throws an error, when both types are not supported
            alert("The type [XSLTProcessor] and the function [XmlDocument.transformNode] are not supported by this browser, can't transform XML document to HTML string!");
            return false;
        }

    }	
	
	$(result).appendTo(element);
	$('html, body').animate({scrollTop:0}, 'fast');
	
	return true;
}

function loadProject () {
	XDocView.project.path=$('[name=projectpath]').val();
	XDocView.project.file=$('[name=projectfile]').val();
	
	$.cookie('projectpath',XDocView.project.path,{expires: 365, path: '/'});
	$.cookie('projectfile',XDocView.project.file,{expires: 365, path: '/'});
	
	$.get(XDocView.project.path+XDocView.project.file,
		function(data){
			result='<project>';
			data=data.replace(/\n/g,'').replace(/\r/g,'');
			var reg = /uses ([^;]+)/;
			var units = reg.exec(data);
			if (units[1]) {
				units=units[1].split(',');
			}
			for (var i=0; i<units.length; i++) {
				reg=/(.*) in '(.*)'/
				line=reg.exec(units[i]);
				if (line && line[1] && line[2]) {
					s1=$.trim(line[1]);
					s2=$.trim(line[2].replace(/\.pas/i,'').replace(/\\/g,'/'));
					projectunits.push(s1);
					projectfiles.push(s2);
					result+='<unit><name>'+s1+'</name><file>'+s2+'</file></unit>';
				}
			}
			
			result+='</project>';
			
			xml=loadXMLData(result);
			transformAndDisplayResult (xml,XDocView.projectXSL,"#unitlist");
			
			$("#navigation").accordion("activate",1);	
			$("input[name=unitfilter]").val("");
		},"text");
}

function loadUnit (unitname, anchorname) {
	var unitfile=findUnitFile(unitname);
	XDocView.currentUnitFile = XDocView.project.path.substring(8)+unitfile;
	var error = false;
	
	if (!unitfile) {
		unitNotFoundDialog(unitname);
		return;
	}
	
	xml=loadXML(XDocView.project.path.substring(8)+unitfile+'.xml')
	
	//xml=loadXMLFile(XDocView.project.path+unitfile+'.xml');
	
	if (!transformAndDisplayResult(xml,XDocView.unitXSL,"#tab-docu")) {		
		$("#tab-docu").html('<div class="ui-state-error"><p>Error creating documentation</p></div>');
		error=true;
	}
	
	if (anchorname) {
		$('html,body').animate({scrollTop: $($("[name="+anchorname+']')).offset().top},'slow');
	}

	XDocView.unitSourceLoaded=false;
/*	
	var data=loadTextFile(XDocView.project.path.substring(8)+unitfile+'.pas');
	data=data.replace(/&/g,'&amp;').replace(/</g,'&lt;').replace(/>/g,'&gt;');
	data='<pre class="syntax pascal">'+data+'</pre>';
	$("#tab-source").html(data);
	$.syntax();
*/
	if (error)
		$("#tabs").tabs("select",1);
	else
		$("#tabs").tabs("select",0);
	
	$(".docheader").prepend('<span class="ui-icon ui-icon-triangle-1-s" style="float:left"></span>').addClass("ui-state-default").addClass("expanded");
	$(".docheader").click(
		function () {if ($(this).hasClass("expanded")) { $(this).collapse_docheader(); }
					 else {$(this).expand_docheader()}}
	);
}

function loadUnitSource () {
	if (!XDocView.unitSourceLoaded) {
		var data=loadTextFile(XDocView.currentUnitFile+'.pas');
		data=data.replace(/&/g,'&amp;').replace(/</g,'&lt;').replace(/>/g,'&gt;');
		data='<pre class="syntax pascal">'+data+'</pre>';
		$("#tab-source").html(data);
		$.syntax();
		XDocView.unitSourceLoaded=true;
	}
}

/**
*
*	Browse file dialog v0.1
*
**/

function openFileDialog () {
	listFolderContent([]);
	$( "#filedialog" ).dialog("open");
}

function listFolderContent (folders) {
	fs = new ActiveXObject("Scripting.FileSystemObject");
	
	$('#dirlist').remove();
	
	if (folders.length==0) {
		var coll = new Enumerator(fs.Drives);
		$('#filedialog').append('<ul id="dirlist"></u>');
		for (coll.moveFirst(); !coll.atEnd(); coll.moveNext()) {
			if (coll.item().IsReady)
				$('#dirlist').append('<li><a onclick="javascript:listFolderContent([\''+coll.item().DriveLetter+':\'])"><span class="ui-icon ui-icon-disk" style="float:left"></span>'+coll.item().DriveLetter+':</a></li>');
		}
		$('#currentpath').text('Computer');
	} else {
		$('#filedialog').append('<ul id="dirlist"></u>');

		foldername='';
		folderparam='[';
		for (i=0; i<folders.length; i++) {
			if (i==folders.length-1)
				$('#dirlist').append('<li><a onclick="javascript:listFolderContent('+folderparam+']);"><span class="ui-icon ui-icon-arrowreturnthick-1-w" style="float:left"></span>..</a></li>');
			if (i>0)
				folderparam+=',';
			foldername+=folders[i]+'\\';
			folderparam+='\''+folders[i]+'\'';
		}
		folderparam+=',';
		
		$('#currentpath').text(foldername);
		folder = fs.GetFolder(foldername);
		
		var coll = new Enumerator(folder.SubFolders);  
		var fileObj;  
		for (coll.moveFirst(); !coll.atEnd(); coll.moveNext()) {  
			fileObj = coll.item();
			if ((fileObj.Attributes & 4) == 0) //Filter system folders (e.g. $Recycler) 4 = System-Flag
				$('#dirlist').append('<li><a onclick="javascript:listFolderContent('+folderparam+'\''+fileObj.Name+'\']);"><span class="ui-icon ui-icon-folder-collapsed" style="float:left"></span>'+fileObj.Name+'</a></li>');
		}
	
		coll = new Enumerator(folder.Files);   
		for (coll.moveFirst(); !coll.atEnd(); coll.moveNext()) {  
			fileObj = coll.item(); 
			if ( ((fileObj.Attributes & 4) == 0)
				 && (fileObj.Name.split('.').pop()=='dpr' ) )	//Filter system files
				$('#dirlist').append('<li><a onclick="javascript:BrowseDialog_FileSelected('+folderparam+'\''+fileObj.Name+'\']);"><span class="ui-icon ui-icon-document" style="float:left"></span>'+fileObj.Name+'</a></li>');
		}
	}
	
	$('#dirlist').menu({width: 'auto'});
}

function BrowseDialog_FileSelected (folders) {
	foldername='file:///';
	for (i=0; i<folders.length-1; i++) {
		foldername+=folders[i]+'\\';
	}

	$('[name=projectpath]').val(foldername);
	$('[name=projectfile]').val(folders[folders.length-1]);
	
	$('#filedialog').dialog("close");
	
	loadProject();
}