<?xml-stylesheet href="doc.xsl" type="text/xsl"?> 
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

<xsl:template match="/">
	<div id="docu">
		<div id="unit">
			<h1><xsl:value-of select="namespace/@name"/></h1>
			Unit <b><xsl:value-of select="namespace/@name"/>.pas</b>
		
			<div>
				<xsl:apply-templates select="namespace/devnotes"/>
			</div>
		
			<xsl:if test="namespace/class">
				<h3 class="docheader">Classes</h3>
				<ul>
					<xsl:for-each select="namespace/class">
						<li>
							<a href="#{@name}"><xsl:value-of select="@name"/></a>
							<xsl:if test="ancestor[1]/@name!='TObject' or 'interfaces/implements'">
								= <i><b>class</b></i> ( <xsl:value-of select="ancestor[1]/@name"/> 
								<xsl:if test="interfaces">
									<xsl:for-each select="interfaces/implements">
										, <xsl:value-of select="@name"/>
									</xsl:for-each>
								</xsl:if>
								)
							</xsl:if>
						</li>
					</xsl:for-each>
				</ul>
			</xsl:if>

			<xsl:if test="namespace/interface">
				<h3 class="docheader">Interfaces</h3>
				<ul>
					<xsl:for-each select="namespace/interface">
						<li>
							<b>interface</b>&#160;<a href="#{@name}"><xsl:value-of select="@name"/></a>
						</li>
					</xsl:for-each>
				</ul>		
			</xsl:if>

			<xsl:if test="namespace/struct">
				<h3 class="docheader">Records</h3>
				<ul>
					<xsl:for-each select="namespace/struct">
						<li>
							<b>record</b>&#160;<a href="#{@name}"><xsl:value-of select="@name"/></a>
						</li>
					</xsl:for-each>
				</ul>
			</xsl:if>
			
			
			<xsl:if test="namespace/enum">
				<h3 class="docheader">Enumerations</h3>
				<ul>
					<xsl:for-each select="namespace/enum">
						<li><b>enum</b>&#160;
							<xsl:choose>
								<xsl:when test="//namespace/enum/devnotes">
									<a href="#{@name}"><xsl:value-of select="@name"/></a>
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="@name"/>
								</xsl:otherwise>
							</xsl:choose>
							&#160;=&#160;(
							<xsl:for-each select="element">
								<xsl:value-of select="@name"/><xsl:if test="position()!=last()">,&#160;</xsl:if>
							</xsl:for-each>
						)&#160;;</li>
					</xsl:for-each>
				</ul>
			</xsl:if>

			<xsl:if test="namespace/const">
				<h3 class="docheader">Constants</h3>
				<ul>
					<xsl:for-each select="namespace/const">
						<xsl:if test="not (//namespace/enum/element/@name = @name)">
							<li><b>const</b>&#160;<xsl:value-of select="@name"/>&#160;:&#160;<xsl:value-of select="@type"/>&#160;=&#160;<xsl:if test="@type = 'string'">&quot;</xsl:if><xsl:value-of select="normalize-space(value)"/><xsl:if test="@type = 'string'">&quot;</xsl:if>;</li>
						</xsl:if>
					</xsl:for-each>
				</ul>
			</xsl:if>
	
			<xsl:if test="namespace/type|namespace/array|namespace/pointer|namespace/classref">
				<h3 class="docheader">Mics. types</h3>
				<ul>
					<xsl:for-each select="namespace/type|namespace/array|namespace/pointer|namespace/classref">
						<xsl:choose>
							<xsl:when test="self::type">
								<li><b>type</b>&#160;<xsl:value-of select="@name"/>&#160;=&#160;<xsl:value-of select="@type"/>;</li>
							</xsl:when>
							<xsl:when test="self::array">
								<li>
									<b>type</b>&#160;<xsl:value-of select="@name"/>&#160;=&#160;array
									<xsl:if test="@low">  <!-- wenn low existiert, dann muss auch high existieren -->
										&#160;[<xsl:value-of select="@low"/>..<xsl:value-of select="@high"/>]
									</xsl:if>
									&#160;of&#160;<xsl:value-of select="element/@type"/>;
								</li>
							</xsl:when>
							<xsl:when test="self::pointer">
								<li>
									<b>type</b>&#160;<xsl:value-of select="@name"/>&#160;=&#160;pointer to&#160;<xsl:value-of select="@type"/>;
								</li>
							</xsl:when>
							<xsl:when test="self::classref">
								<li>
									<b>type</b>&#160;<xsl:value-of select="@name"/>&#160;=&#160;class of&#160;<xsl:value-of select="@ref"/>;
								</li>
							</xsl:when>
						</xsl:choose>
					</xsl:for-each>
				</ul>
			</xsl:if>
		
			<xsl:if test="namespace/procedure|namespace/function">
				<h3 class="docheader">Functions / Procedures</h3>
				<ul>
					<xsl:for-each select="namespace/procedure|namespace/function">
						<li><xsl:apply-templates select="."/></li>
					</xsl:for-each>
				</ul>
			</xsl:if>
		</div>
		
		<xsl:apply-templates select="namespace/enum"/>
		<xsl:apply-templates select="namespace/struct"/>
		<xsl:apply-templates select="namespace/interface"/>	
		<xsl:apply-templates select="namespace/class"/>
	</div>
</xsl:template>

<xsl:template match="interface">
	<div class="class">
		<a name="{@name}"><h2><xsl:value-of select="@name"/></h2></a>
		<xsl:apply-templates select="devnotes"/>
	
		<xsl:if test="function|procedure">
			<h3 class="docheader">Methods</h3>
			<div style="margin-left:1em;">
				<xsl:apply-templates select="function|procedure"/>
			</div>
		</xsl:if>
	
		<xsl:if test="property">
			<h3 class="docheader">Properties</h3>
			<div style="margin-left:1em;">
				<xsl:apply-templates select="property"/>
			</div>
		</xsl:if>
	</div>
</xsl:template>

<xsl:template match="class">
	<div class="class">
		<a name="{@name}"><h2><xsl:value-of select="@name"/></h2></a>
		<div style="margin-left:1em;">
			<xsl:apply-templates select="devnotes"/>
			<h3 class="docheader">Ancestors</h3>
			<div id="ancestor" class="collapsable">
				<xsl:apply-templates select="ancestor"/>
			</div>
			<xsl:if test="interfaces">
				<h2>Implements Interfaces</h2>
				<div style="margin-left:1em">
					<ul>
						<xsl:for-each select="interfaces/implements">
							<li><xsl:value-of select="@name"/></li>
						</xsl:for-each>
					</ul>
				</div>
			</xsl:if>
			<xsl:apply-templates select="members"/>
		</div>
	</div>
</xsl:template>

<xsl:template match="struct">
	<div class="class">
		<a name="{@name}"><h2><xsl:value-of select="@name"/></h2></a>
		<div style="margin-left:1em;">
			<xsl:apply-templates select="devontes"/>
			
			<xsl:if test="field">
				<h3 class="docheader">Fields</h3>
				<ul>
					<xsl:for-each select="field">
						<li><xsl:apply-templates select="."/></li>
					</xsl:for-each>
				</ul>
			</xsl:if>

			<xsl:if test="constructor|function|procedure">
				<h3 class="docheader">Methods</h3>
				<ul>
					<xsl:if test="constructor">
						<li><xsl:apply-templates select="constructor"/></li>
					</xsl:if>
					<xsl:if test="function|procedure">
						<xsl:for-each select="function|procedure">
							<li><xsl:apply-templates select="."/></li>
						</xsl:for-each>
					</xsl:if>
				</ul>
			</xsl:if>
			
			<xsl:if test="property">
				<h3 class="docheader">Properties</h3>
				<ul>
					<xsl:for-each select="property">
						<li><xsl:apply-templates select="."/></li>
					</xsl:for-each>
				</ul>
			</xsl:if>
		</div>
	</div>
</xsl:template>

<xsl:template match="enum">
	<xsl:if test="devnotes">
		<div class="class">
			<a name="{@name}"><h2><xsl:value-of select="@name"/></h2></a>
			<div style="margin-left:1em;">
				<b>enum</b>&#160;<a href="#{@name}"><xsl:value-of select="@name"/></a>&#160;=&#160;(
					<xsl:for-each select="element">
						<xsl:value-of select="@name"/><xsl:if test="position()!=last()">,&#160;</xsl:if>
					</xsl:for-each>
				)&#160;;
		
				<xsl:apply-templates select="devnotes"/>
			</div>
		</div>
	</xsl:if>
</xsl:template>

<xsl:template match="devnotes">
	<xsl:apply-templates />

	<!--<p><xsl:value-of select="text()"/></p>
	<xsl:apply-templates select="summary"/>
	<xsl:apply-templates select="remarks"/>
	<xsl:apply-templates select="example"/>
	<xsl:if test="seealso">
		<h4>See Also</h4>
		<xsl:apply-templates select="seealso"/>
	</xsl:if>
	<xsl:apply-templates select="todo"/>-->
</xsl:template>

<xsl:template match="summary">
	<p><xsl:apply-templates/></p>
</xsl:template>

<xsl:template match="todo">
	<h4>ToDo:</h4>
	<p style="margin-left:2em;"><xsl:apply-templates/></p>
</xsl:template>

<xsl:template match="remarks">
    <h4>Remarks</h4>
	<xsl:apply-templates/>
</xsl:template>

<xsl:template match="example">
    <h4>Example</h4>
	<xsl:apply-templates/>
</xsl:template>

<xsl:template match="ancestor">
	-<a href="javascript:loadUnit('{@namespace}','{@name}')"><xsl:value-of select="@name"/></a>
	<xsl:if test="ancestor">
		<div style="margin-left:1em;"><xsl:apply-templates select="ancestor"/></div>
	</xsl:if>
	<!--<xsl:apply-templates select="methodref"/>-->
</xsl:template>


<xsl:template match="methodref">
	<xsl:value-of select="@visibility"/>: <xsl:value-of select="@name"/><br/>
</xsl:template>

<xsl:template match="members">
	<h3 class="docheader">Members</h3>
	<div style="margin-left:1em;">
	
		<xsl:if test="field">
			<h4 class="docheader">Fields</h4>
			<ul>
				<xsl:for-each select="field">
					<li><xsl:apply-templates select="."/></li>
				</xsl:for-each>
			</ul>
		</xsl:if>

		<xsl:if test="constructor|destructor|funtion|procedure">
			<h4 class="docheader">Methods</h4>
			<ul>
				<xsl:if test="constructor">
					<xsl:for-each select="constructor">
						<li><xsl:apply-templates select="."/></li>
					</xsl:for-each>
				</xsl:if>
				<xsl:if test="destructor">
					<xsl:for-each select="destructor">
						<li><xsl:apply-templates select="."/></li>
					</xsl:for-each>
				</xsl:if>
				<xsl:if test="function|procedure">
					<xsl:for-each select="function|procedure">
						<li><xsl:apply-templates select="."/></li>
					</xsl:for-each>
				</xsl:if>
			</ul>
		</xsl:if>

		<xsl:if test="property">
			<h4 class="docheader">Properties</h4>
			<ul>
				<xsl:for-each select="property">
					<li><xsl:apply-templates select="."/></li>
				</xsl:for-each>
			</ul>
		</xsl:if>
	</div>
</xsl:template>

<xsl:template match="field">
	<a name="{@name}"><b><xsl:value-of select="@visibility"/></b>&#160;<xsl:value-of select="@name"/> : 
	<xsl:choose>
		<xsl:when test="@type">
			<xsl:value-of select="@type"/>
		</xsl:when>
		<xsl:when test="type">
			<xsl:value-of select="type/@type"/>
		</xsl:when>
	</xsl:choose>
	</a><br/>
	<div class="field">
		<xsl:apply-templates select="summary"/>
		<xsl:apply-templates select="value"/>
		<xsl:apply-templates select="remarks"/>
		<xsl:apply-templates select="example"/>
		<xsl:if test="seealso">
			<div class="seealso">
			<b><i>See Also</i></b><br/>
			<xsl:apply-templates select="seealso"/>
			</div>
		</xsl:if>
	</div>
</xsl:template>

<xsl:template match="constructor|function|procedure|destructor">
	<a name="{@name}"><b>
		<xsl:value-of select="@visibility"/>
		<xsl:choose>
			<xsl:when test="self::function"> function </xsl:when>
			<xsl:when test="self::procedure"> procedure </xsl:when>
			<xsl:when test="self::constructor"> constructor </xsl:when>
			<xsl:when test="self::destructor"> destructor </xsl:when>
		</xsl:choose>
		</b>
		<xsl:value-of select="@name"/>
		&#160;(
		<xsl:if test="parameters/parameter">
			<xsl:for-each select="parameters/parameter">
				<xsl:if test="@paramflags">
					<b><i><xsl:value-of select="@paramflags"/></i></b>&#160;
				</xsl:if>
				<xsl:value-of select="@name"/>&#160;:&#160;
				<xsl:choose>
					<xsl:when test="@type"><xsl:value-of select="@type"/></xsl:when>
					<xsl:when test="array">
						<b><i>array of</i></b>&#160;<xsl:value-of select="array/element/@type"/>
					</xsl:when>
				</xsl:choose>
				<xsl:if test="value">
					&#160;=&#160;<xsl:value-of select="value"/>
				</xsl:if>
				<xsl:if test="position()!=last()">;&#160;</xsl:if>
			</xsl:for-each>
		</xsl:if>
		)
		<xsl:if test="parameters/retval">
			&#160;:&#160;<xsl:value-of select="parameters/retval/@type"/>
		</xsl:if>
		;
		<xsl:if test="@procflags">
			&#160;<b><xsl:value-of select="@procflags"/></b>;
		</xsl:if>
	</a>
	<div class="member">
		<xsl:apply-templates select="devnotes/summary"/>

		<xsl:apply-templates select="parameters"/>
		
		<xsl:if test="devnotes/retval">
			<h4>Return values</h4>
			<ul>
				<xsl:for-each select="devnotes/retval">
					<li><b><xsl:value-of select="@name"/></b>&#160;-&#160;<xsl:value-of select="."/></li>
				</xsl:for-each>
			</ul>
		</xsl:if>
		
		<xsl:apply-templates select="devnotes/todo"/>

		<xsl:apply-templates select="remarks"/>
		<xsl:apply-templates select="example"/>
		<xsl:if test="seealso">
			<h4>See Also</h4>
			<xsl:apply-templates select="seealso"/>
		</xsl:if>
	</div>
</xsl:template>

<xsl:template match="parameters">
	<xsl:if test="../devnotes/param">
	<h4>Parameters</h4>
	<ul>
		<xsl:for-each select="parameter">
			<xsl:if test="../../devnotes/param/@name = ./@name">
				<li>
					<a name="{ancestor::members[1]/../@name}.{../../@name}.{@name}"><b>
					<xsl:if test="@paramflags">
						<i><xsl:value-of select="@paramflags"/></i>&#160;
					</xsl:if>
					<xsl:value-of select="@name"/>&#160;:&#160;
					<xsl:choose>
						<xsl:when test="@type"><xsl:value-of select="@type"/></xsl:when>
						<xsl:when test="array">
							<b><i>array of</i></b>&#160;<xsl:value-of select="array/element/@type"/>
						</xsl:when>
					</xsl:choose>
					<xsl:if test="value">
						&#160;=&#160;<xsl:value-of select="value"/>
					</xsl:if>
					</b></a>
					&#160;-&#160;
					<xsl:apply-templates select="../../devnotes/param[@name=@name]"/>
				</li>
			</xsl:if>
		</xsl:for-each>
	</ul>
	</xsl:if>
</xsl:template>

<xsl:template match="property">
	<a name="{@name}">
		<b><xsl:value-of select="@visibility"/></b>&#160;<xsl:value-of select="@name"/> : <xsl:value-of select="@type"/>
	</a>
	<div class="member">
		<xsl:apply-templates select="devnotes/summary"/>
		<xsl:if test="@read">
			<b>read</b>&#160;<a href="#{@read}"><xsl:value-of select="@read"/></a><br/>
		</xsl:if>
		<xsl:if test="@write">
			<b>write</b>&#160;<a href="#{@write}"><xsl:value-of select="@write"/></a><br/>
		</xsl:if>
	</div>
</xsl:template>

<xsl:template match="parameter">
    <dt><i>
		<xsl:if test="@paramflags">
			<b><xsl:value-of select="@paramflags"/></b>&#160;
		</xsl:if>
		<xsl:value-of select="@name"/> : <xsl:value-of select="@type"/>
	</i></dt>
	<!--<dd><xsl:apply-templates/></dd>-->
</xsl:template>

<xsl:template match="value">
    <h4>Value</h4>
	<xsl:apply-templates/>
</xsl:template>

<xsl:template match="retval">
    <b>Returns</b>&#160;<xsl:value-of select="@type"/><br/>
	<!--<xsl:apply-templates/>-->
</xsl:template>

<xsl:template match="exception">
    <dt><i><xsl:value-of select="@name"/></i></dt>
	<dd><xsl:apply-templates/></dd>
</xsl:template>


<xsl:template match="seealso">
    <xsl:if test="cref"><a href="#{@cref}"><xsl:value-of select="@cref"/></a>&#160;</xsl:if>
</xsl:template>

<xsl:template match="text()"><xsl:value-of select="."/></xsl:template>

<xsl:template match="para"><p><xsl:apply-templates/></p></xsl:template>

<xsl:template match="code"><pre><xsl:value-of select="."/></pre></xsl:template>

<xsl:template match="see">
    <xsl:choose>
        <xsl:when test="@langword"><code><xsl:value-of select="@langword"/></code></xsl:when>
        <xsl:when test="@cref">(<i>siehe: <a href="#{@cref}"><xsl:value-of select="@cref"/></a></i>)</xsl:when>
    </xsl:choose>
</xsl:template>

<xsl:template match="list"><table><xsl:apply-templates/></table></xsl:template>

<xsl:template match="listheader"><tr><xsl:apply-templates/></tr></xsl:template>

<xsl:template match="item"><tr><xsl:apply-templates/></tr></xsl:template>

<xsl:template match="term"><td><xsl:apply-templates/></td></xsl:template>

<xsl:template match="description"><td><xsl:apply-templates/></td></xsl:template>

<xsl:template match="c"><code><xsl:apply-templates/></code></xsl:template>

<xsl:template match="paramref">
	<i>
	<xsl:variable name="varParamName">
		<xsl:choose>
			<xsl:when test="@name">
				<xsl:value-of select="@name"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="."/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>
		
	<xsl:choose>
		<xsl:when test="ancestor::devnotes[1]/param/@name = $varParamName">
			<a href="#{ancestor::members[1]/../@name}.{ancestor::devnotes[1]/../@name}.{$varParamName}"><xsl:value-of select="$varParamName"/></a>
		</xsl:when>
		<xsl:otherwise>
			<xsl:value-of select="$varParamName"/>
		</xsl:otherwise>
	</xsl:choose>

	</i>
</xsl:template>
	

<!-- Alles ausserhalb von Klassen -->

<xsl:template match="pre"><pre><xsl:apply-templates/></pre></xsl:template>
<xsl:template match="i"><i><xsl:apply-templates/></i></xsl:template>
<xsl:template match="b"><b><xsl:apply-templates/></b></xsl:template>


</xsl:stylesheet>